<?php
/*======================================================================*\
|| #################################################################### ||
|| # Advanced Product Management [APM] 4.0.001  by HacNho              # ||
|| # Copyright (C) 2005-2008 by HacNho, All rights reserved.          # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 4.0.x                             # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # ---------------------------------------------------------------- # ||
|| # Discussion and support available at                              # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=229418           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('FORCE_HOOKS', true);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('plugins','style','language','cpoption','user', 'cron');
$specialtemplates = array('products');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_hook.php');
require_once(DIR . '/includes/adminfunctions_options.php');
require_once(DIR . '/includes/adminfunctions_plugin.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions_language.php');

//inits classloader -- required to make vB_Cache work
require_once(DIR . '/includes/class_bootstrap_framework.php');
vB_Bootstrap_Framework::init();

// ######################## CHECK ADMIN PERMISSIONS #######################
// don't allow demo version or admin with no permission to administer plugins
if (is_demo_mode() OR !can_administer('canadminplugins'))
{
	print_cp_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array(
	'productid' => TYPE_STR,
	'pluginid'	=> TYPE_UINT
));

// ############################# LOG ACTION ###############################
log_admin_action(iif($vbulletin->GPC['productid'] != '', 'product id = ' . $vbulletin->GPC['productid']));

// #############################################################################
// ########################### START MAIN SCRIPT ###############################
// #############################################################################
/**
* Prints a setting group for use in apm_options.php?do=options
*
* @param	string	Settings group ID
* @param	boolean	Show advanced settings?
*/


// #############################################################################
/* OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA */
/* reference from adminfunctions_options.php */


function print_setting_group_apm($dogroup, $advanced = 0)
{
	global $settingscache, $grouptitlecache, $vbulletin, $vbphrase, $bgcounter, $settingphrase, $stylevar, $gdinfo, $productid;

	if (!is_array($settingscache["$dogroup"]))
	{
		return;
	}

	print_table_header(
		$settingphrase["settinggroup_$grouptitlecache[$dogroup]"]
		 . iif($vbulletin->debug,
		 	'<span class="normal">' .
			construct_link_code($vbphrase['edit'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=editgroup&amp;grouptitle=$dogroup&amp;productid=" . $vbulletin->GPC['productid']) .
			construct_link_code($vbphrase['delete'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=removegroup&amp;grouptitle=$dogroup&amp;productid=" . $vbulletin->GPC['productid']) .
			construct_link_code($vbphrase['add_setting'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=addsetting&amp;grouptitle=$dogroup&amp;productid=" . $vbulletin->GPC['productid']) .
			'</span>'
		)
	);

	$bgcounter = 1;

	foreach ($settingscache["$dogroup"] AS $settingid => $setting)
	{

		if (($advanced OR !$setting['advanced']) AND !empty($setting['varname']))
		{
			print_setting_row_apm($setting, $settingphrase);
		}
	}
}

/**
* Prints a setting row for use in options.php?do=options
*
* @param	array	Settings array
* @param	array	Phrases
*/
function print_setting_row_apm($setting, $settingphrase)
{
	global $vbulletin, $vbphrase, $bgcounter, $settingphrase, $stylevar;

	$settingid = $setting['varname'];

//	echo '<tbody>';
	print_description_row(
		iif($vbulletin->debug, '<div class="smallfont" style="float:' . vB_Template_Runtime::fetchStyleVar('right') . '">' . 
		construct_link_code($vbphrase['edit'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=editsetting&amp;varname=$setting[varname]&amp;productid=" . $vbulletin->GPC['productid']) . 
		construct_link_code($vbphrase['delete'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=removesetting&varname=$setting[varname]&amp;productid=" . $vbulletin->GPC['productid']) . '</div>') .
		'<div>' . $settingphrase["setting_$setting[varname]_title"] . "<a name=\"$setting[varname]\"></a></div>",
		0, 2, 'optiontitle' . ($vbulletin->debug ? "\" title=\"\$vbulletin->options['" . $setting['varname'] . "']" : '')
	);
//	echo "</tbody><tbody id=\"tbody_$settingid\">\r\n";

	// make sure all rows use the alt1 class
	$bgcounter--;

	$description = "<div class=\"smallfont\"" . ($vbulletin->debug ? "title=\"\$vbulletin->options['$setting[varname]']\"" : '') . ">" . $settingphrase["setting_$setting[varname]_desc"] . '</div>';
	$name = "setting[$setting[varname]]";
	$right = "<span class=\"smallfont\">$vbphrase[error]</span>";
	$width = 40;
	$rows = 8;

	if (preg_match('#^input:?(\d+)$#s', $setting['optioncode'], $matches))
	{
		$width = $matches[1];
		$setting['optioncode'] = '';
	}
	else if (preg_match('#^textarea:?(\d+)(,(\d+))?$#s', $setting['optioncode'], $matches))
	{
		$rows = $matches[1];
		if ($matches[2])
		{
			$width = $matches[3];
		}
		$setting['optioncode'] = 'textarea';
	}
	else if (preg_match('#^bitfield:(.*)$#siU', $setting['optioncode'], $matches))
	{
		$setting['optioncode'] = 'bitfield';
		$setting['bitfield'] =& fetch_bitfield_definitions($matches[1]);
	}
	else if (preg_match('#^(select|radio):(piped|eval)(\r\n|\n|\r)(.*)$#siU', $setting['optioncode'], $matches))
	{
		$setting['optioncode'] = "$matches[1]:$matches[2]";
		$setting['optiondata'] = trim($matches[4]);
	}
	else if (preg_match('#^usergroup:?(\d+)$#s', $setting['optioncode'], $matches))
	{
		$size = intval($matches[1]);
		$setting['optioncode'] = 'usergroup';
	}
	else if (preg_match('#^(usergroupextra)(\r\n|\n|\r)(.*)$#siU', $setting['optioncode'], $matches))
	{
		$setting['optioncode'] = 'usergroupextra';
		$setting['optiondata'] = trim($matches[3]);
	}

	switch ($setting['optioncode'])
	{
		// input type="text"
		case '':
		{
			print_input_row($description, $name, $setting['value'], 1, $width);
		}
		break;

		// input type="radio"
		case 'yesno':
		{
			print_yes_no_row($description, $name, $setting['value']);
		}
		break;

		// textarea
		case 'textarea':
		{
			print_textarea_row($description, $name, $setting['value'], $rows, "$width\" style=\"width:90%");
		}
		break;

		// bitfield
		case 'bitfield':
		{
			$setting['value'] = intval($setting['value']);
			$setting['html'] = '';

			if ($setting['bitfield'] === NULL)
			{
				print_label_row($description, construct_phrase("<strong>$vbphrase[settings_bitfield_error]</strong>", implode(',', vB_Bitfield_Builder::fetch_errors())), '', 'top', $name, 40);
			}
			else
			{
				#$setting['html'] .= "<fieldset><legend>$vbphrase[yes] / $vbphrase[no]</legend>";
				$setting['html'] .= "<div id=\"ctrl_setting[$setting[varname]]\" class=\"smallfont\">\r\n";
				$setting['html'] .= "<input type=\"hidden\" name=\"setting[$setting[varname]][0]\" value=\"0\" />\r\n";
				foreach ($setting['bitfield'] AS $key => $value)
				{
					$value = intval($value);
					$setting['html'] .= "<table style=\"width:175px; float:" . vB_Template_Runtime::fetchStyleVar('left') . "\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr valign=\"top\">
					<td><input type=\"checkbox\" name=\"setting[$setting[varname]][$value]\" id=\"setting[$setting[varname]]_$key\" value=\"$value\"" . (($setting['value'] & $value) ? ' checked="checked"' : '') . " /></td>
					<td width=\"100%\" style=\"padding-top:4px\"><label for=\"setting[$setting[varname]]_$key\" class=\"smallfont\">" . fetch_phrase_from_key($key) . "</label></td>\r\n</tr></table>\r\n";
				}

				$setting['html'] .= "</div>\r\n";
				#$setting['html'] .= "</fieldset>";
				print_label_row($description, $setting['html'], '', 'top', $name, 40);
			}
		}
		break;

		// select:piped
		case 'select:piped':
		{
			print_select_row($description, $name, fetch_piped_options($setting['optiondata']), $setting['value']);
		}
		break;

		// radio:piped
		case 'radio:piped':
		{
			print_radio_row($description, $name, fetch_piped_options($setting['optiondata']), $setting['value'], 'smallfont');
		}
		break;

		// select:eval
		case 'select:eval':
		{
			$options = null;

			eval($setting['optiondata']);

			if (is_array($options) AND !empty($options))
			{
				print_select_row($description, $name, $options, $setting['value']);
			}
			else
			{
				print_input_row($description, $name, $setting['value']);
			}
		}
		break;

		// radio:eval
		case 'radio:eval':
		{
			$options = null;

			eval($setting['optiondata']);

			if (is_array($options) AND !empty($options))
			{
				print_radio_row($description, $name, $options, $setting['value'], 'smallfont');
			}
			else
			{
				print_input_row($description, $name, $setting['value']);
			}
		}
		break;

		case 'username':
		{
			if (intval($setting['value']) AND $userinfo = $vbulletin->db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = " . intval($setting['value'])))
			{
				print_input_row($description, $name, $userinfo['username'], false);
			}
			else
			{
				print_input_row($description, $name);
			}
			break;
		}

		case 'usergroup':
		{
			$usergrouplist = array();
			foreach ($vbulletin->usergroupcache AS $usergroup)
			{
				$usergrouplist["$usergroup[usergroupid]"] = $usergroup['title'];
			}

			if ($size > 1)
			{
				print_select_row($description, $name . '[]', array(0 => '') + $usergrouplist, unserialize($setting['value']), false, $size, true);
			}
			else
			{
				print_select_row($description, $name, $usergrouplist, $setting['value']);
			}
			break;
		}

		case 'usergroupextra':
		{
			$usergrouplist = fetch_piped_options($setting['optiondata']);
			foreach ($vbulletin->usergroupcache AS $usergroup)
			{
				$usergrouplist["$usergroup[usergroupid]"] = $usergroup['title'];
			}

			print_select_row($description, $name, $usergrouplist, $setting['value']);
			break;
		}

		// arbitrary number of <input type="text" />
		case 'multiinput':
		{
			$setting['html'] = "<div id=\"ctrl_$setting[varname]\"><fieldset id=\"multi_input_fieldset_$setting[varname]\" style=\"padding:4px\">";

			$setting['values'] = unserialize($setting['value']);
			$setting['values'] = (is_array($setting['values']) ? $setting['values'] : array());
			$setting['values'][] = '';

			foreach ($setting['values'] AS $key => $value)
			{
				$setting['html'] .= "<div id=\"multi_input_container_$setting[varname]_$key\">" . ($key + 1) . " <input type=\"text\" class=\"bginput\" name=\"setting[$setting[varname]][$key]\" id=\"multi_input_$setting[varname]_$key\" size=\"40\" value=\"" . htmlspecialchars_uni($value) . "\" tabindex=\"1\" /></div>";
			}

			$i = sizeof($setting['values']);
			if ($i == 0)
			{
				$setting['html'] .= "<div><input type=\"text\" class=\"bginput\" name=\"setting[$setting[varname]][$i]\" size=\"40\" tabindex=\"1\" /></div>";
			}

			$setting['html'] .= "
				</fieldset>
				<div class=\"smallfont\"><a href=\"#\" onclick=\"return multi_input['$setting[varname]'].add()\">Add Another Option</a></div>
				<script type=\"text/javascript\">
				<!--
				multi_input['$setting[varname]'] = new vB_Multi_Input('$setting[varname]', $i, '" . $vbulletin->options['cpstylefolder'] . "');
				//-->
				</script>
			";

			print_label_row($description, $setting['html']);
			break;
		}

		// default registration options
		case 'defaultregoptions':
		{
			$setting['value'] = intval($setting['value']);

			$checkbox_options = array(
				'receiveemail' => 'display_email',
				'adminemail' => 'receive_admin_emails',
				'invisiblemode' => 'invisible_mode',
				'vcard' => 'allow_vcard_download',
				'signature' => 'display_signatures',
				'avatar' => 'display_avatars',
				'image' => 'display_images',
				'showreputation' => 'display_reputation',
				'enablepm' => 'receive_private_messages',
				'emailonpm' => 'send_notification_email_when_a_private_message_is_received',
				'pmpopup' => 'pop_up_notification_box_when_a_private_message_is_received',
			);

			$setting['value'] = intval($setting['value']);

			$setting['html'] = '';
			#$setting['html'] .= "<fieldset><legend>$vbphrase[yes] / $vbphrase[no]</legend>";
			$setting['html'] .= "<div id=\"ctrl_setting[$setting[varname]]\" class=\"smallfont\">\r\n";
			$setting['html'] .= "<input type=\"hidden\" name=\"setting[$setting[varname]][0]\" value=\"0\" />\r\n";
			foreach ($checkbox_options AS $key => $phrase)
			{
				$value = $vbulletin->bf_misc_regoptions["$key"];

				$setting['html'] .= "<table style=\"width:175px; float:" . vB_Template_Runtime::fetchStyleVar('left') . "\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr valign=\"top\">
				<td><input type=\"checkbox\" name=\"setting[$setting[varname]][$value]\" id=\"setting[$setting[varname]]_$key\" value=\"$value\"" . (($setting['value'] & $value) ? ' checked="checked"' : '') . " /></td>
				<td width=\"100%\" style=\"padding-top:4px\"><label for=\"setting[$setting[varname]]_$key\" class=\"smallfont\">" . fetch_phrase_from_key($phrase) . "</label></td>\r\n</tr></table>\r\n";
			}
			#$setting['html'] .= "</fieldset>";
			print_label_row($description, $setting['html'], '', 'top', $name, 40);
		}
		break;

		// cp folder options
		case 'cpstylefolder':
		{
			if ($folders = fetch_cpcss_options() AND !empty($folders))
			{
				print_select_row($description, $name, $folders, $setting['value'], 1, 6);
			}
			else
			{
				print_input_row($description, $name, $setting['value'], 1, 40);
			}
		}
		break;

		// cookiepath / cookiedomain options
		case 'cookiepath':
		case 'cookiedomain':
		{
			$func = 'fetch_valid_' . $setting['optioncode'] . 's';

			$cookiesettings = $func(($setting['optioncode'] == 'cookiepath' ? $vbulletin->script : $_SERVER['HTTP_HOST']), $vbphrase['blank']);

			$setting['found'] = in_array($setting['value'], array_keys($cookiesettings));

			$setting['html'] = "
			<div id=\"ctrl_$setting[varname]\">
			<fieldset>
				<legend>$vbphrase[suggested_settings]</legend>
				<div style=\"padding:4px\">
					<select name=\"setting[$setting[varname]]\" tabindex=\"1\" class=\"bginput\">" .
						construct_select_options($cookiesettings, $setting['value']) . "
					</select>
				</div>
			</fieldset>
			<br />
			<fieldset>
				<legend>$vbphrase[custom_setting]</legend>
				<div style=\"padding:4px\">
					<label for=\"{$settingid}o\"><input type=\"checkbox\" id=\"{$settingid}o\" name=\"setting[{$settingid}_other]\" tabindex=\"1\" value=\"1\"" . ($setting['found'] ? '' : ' checked="checked"') . " />$vbphrase[use_custom_setting]
					</label><br />
					<input type=\"text\" class=\"bginput\" size=\"25\" name=\"setting[{$settingid}_value]\" value=\"" . ($setting['found'] ? '' : $setting['value']) . "\" />
				</div>
			</fieldset>
			</div>";

			print_label_row($description, $setting['html'], '', 'top', $name, 50);
		}
		break;

		// just a label
		default:
		{
			$handled = false;
			($hook = vBulletinHook::fetch_hook('admin_options_print')) ? eval($hook) : false;
			if (!$handled)
			{
				eval("\$right = \"<div id=\\\"ctrl_setting[$setting[varname]]\\\">$setting[optioncode]</div>\";");
				print_label_row($description, $right, '', 'top', $name, 50);
			}
		}
		break;
	}

//	echo "</tbody>\r\n";

	$valid = exec_setting_validation_code($setting['varname'], $setting['value'], $setting['validationcode']);

//	echo "<tbody id=\"tbody_error_$settingid\" style=\"display:" . (($valid === 1 OR $valid === true) ? 'none' : '') . "\"><tr><td class=\"alt1 smallfont\" colspan=\"2\"><div style=\"padding:4px; border:solid 1px red; background-color:white; color:black\"><strong>$vbphrase[error]</strong>:<div id=\"span_error_$settingid\">$valid</div></div></td></tr></tbody>";
	if (!$valid)
	{
		echo "<tr><td class=\"alt1 smallfont\" colspan=\"2\"><div style=\"padding:4px; border:solid 1px red; background-color:white; color:black\"><strong>$vbphrase[error]</strong>:<div id=\"span_error_$settingid\">$valid</div></div></td></tr>";
	}
}

// #############################

// #############################################################################
/* OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA */
/* reference from adminfunctions_plugin.php */

/**
if (!function_exists('delete_product'))
{
	function delete_product($productid, $compliant_35 = false)
	{
		global $vbulletin;
	
		$productid = $vbulletin->db->escape_string($productid);
	
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "product WHERE productid = '$productid'");
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "productcode WHERE productid = '$productid'");
		if ($compliant_35 == false)
		{
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "productdependency WHERE productid = '$productid'");
		}
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE product = '$productid'");
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE product = '$productid' AND languageid = -1");
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE product = '$productid'");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE product = '$productid' AND styleid = -10");
	if ($for_product_upgrade)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "template SET
				styleid = -10
			WHERE product = '$productid' AND styleid = -1
		");
	}
	else
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE product = '$productid' AND styleid = -1");

		$ids = array();
		
		if (!$compliant_35)
		{
			$types = $vbulletin->db->query_read("
				SELECT contenttypeid
				FROM " . TABLE_PREFIX . "contenttype AS c
				INNER JOIN " . TABLE_PREFIX . "package AS p ON (c.packageid = p.packageid)
				WHERE
					p.productid = '$productid'
						AND
					c.canattach = 1
			");

			while ($type = $vbulletin->db->fetch_array($types))
			{
				$ids[] = $type['contenttypeid'];
			}

			if (!empty($ids))
			{
				$attachdata =& datamanager_init('Attachment', $vbulletin, ERRTYPE_SILENT, 'attachment');
				$attachdata->set_condition("a.contenttypeid IN (" . implode(",", $ids) . ")");
				$attachdata->delete(true, false);
			}
		}
	}
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "setting WHERE product = '$productid' AND volatile = 1");
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "settinggroup WHERE product = '$productid' AND volatile = 1");
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "adminhelp WHERE product = '$productid' AND volatile = 1");
		if ($compliant_35 == false)
		{
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "cron WHERE product = '$productid' AND volatile = 1");
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "faq WHERE product = '$productid' AND volatile = 1");
		}
		$vbulletin->db->hide_errors();
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "moderatorlog WHERE product = '$productid'");
		$vbulletin->db->show_errors();
	}

}
**/
/**
function version_sort_apm($a, $b)
{
	if ($a == $b)
	{
		return 0;
	}

	return (is_newer_version($a, $b) ? 1 : -1);
}
**/

// #############################################################################
/* OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA */
/* reference from plugin.php */


if ($_REQUEST['do'] != 'download' AND $_REQUEST['do'] != 'productexport')
{
	print_cp_header($vbphrase['plugin_products_system']);
}

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'product';
}

if (in_array($_REQUEST['do'], array('files', 'edit', 'add', 'product', 'productadd', 'productedit')))
{
	if (!$vbulletin->options['enablehooks'] OR defined('DISABLE_HOOKS'))
	{
		print_table_start();
		if (!$vbulletin->options['enablehooks'])
		{
			print_description_row($vbphrase['plugins_disabled_options']);
		}
		else
		{
			print_description_row($vbphrase['plugins_disable_config']);
		}
		print_table_footer(2, '', '', false);
	}
}

if ($vbulletin->options['templateversion'] < '3.8')
{
 $vbulletin->input->clean_gpc('r', 'vbulletin_collapse', TYPE_NOCLEAN);
}  
$vbcollapse = array();



if (!empty($vbulletin->GPC['vbulletin_collapse']))
{
	$val = preg_split('#\n#', $vbulletin->GPC['vbulletin_collapse'], -1, PREG_SPLIT_NO_EMPTY);
	foreach ($val AS $key)
	{
		$vbcollapse["collapseobj_$key"] = 'display:none;';
		$vbcollapse["collapseimg_$key"] = '_collapsed';
		$vbcollapse["collapsecel_$key"] = '_collapsed';
	}
	unset($val);
}

// ###################### Start import plugin XML #######################
if ($_REQUEST['do'] == 'files')
{
	$products = fetch_product_list();

	// download form
	print_form_header('apm_product', 'download', 0, 1, 'downloadform" target="download');
	print_table_header($vbphrase['download']);
	print_input_row($vbphrase['filename'], 'filename', 'vbulletin-plugins.xml');

	$plugins = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "plugin ORDER BY hookname, title");
	$prevhook = '';
	while ($plugin = $db->fetch_array($plugins))
	{
		if ($plugin['hookname'] != $prevhook)
		{
			$prevhook = $plugin['hookname'];
			print_description_row("$vbphrase[hook_location] : " . $plugin['hookname'], 0, 2, 'tfoot');
		}

		$title = htmlspecialchars_uni($plugin['title']);
		$title = $plugin['active'] ? $title : "<strike>$title</strike>";

		$product = $products[($plugin['product'] ? $plugin['product'] : 'vbulletin')];
		if (!$product)
		{
			$product = "<em>$plugin[product]</em>";
		}

		print_label_row("
			<label for=\"cb$plugin[pluginid]\">
			<input type=\"checkbox\" id=\"cb$plugin[pluginid]\" name=\"download[]\" value=\"$plugin[pluginid]\" />$title</label>
		", $product);
	}

	print_submit_row($vbphrase['download']);

	?>
	<script type="text/javascript">
	<!--
	function js_confirm_upload(tform, filefield)
	{
		if (filefield.value == "")
		{
			return confirm("<?php echo construct_phrase($vbphrase['you_did_not_specify_a_file_to_upload'], '" + tform.serverfile.value + "'); ?>");
		}
		return true;
	}
	//-->
	</script>
	<?php

	print_form_header('apm_product', 'doimport', 1, 1, 'uploadform" onsubmit="return js_confirm_upload(this, this.pluginfile);');
	print_table_header($vbphrase['import_plugin_xml_file']);
	print_upload_row($vbphrase['upload_xml_file'], 'pluginfile', 999999999);
	print_input_row($vbphrase['import_xml_file'], 'serverfile', './includes/xml/plugins.xml');
	print_submit_row($vbphrase['import'], 0);
}

// #############################################################################
if ($_POST['do'] == 'doimport')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'serverfile' => TYPE_STR,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'pluginfile' => TYPE_FILE
	));

	// got an uploaded file?
	if (file_exists($vbulletin->GPC['pluginfile']['tmp_name']))
	{
		$xml = file_read($vbulletin->GPC['pluginfile']['tmp_name']);
	}
	// no uploaded file - got a local file?
	else if (file_exists($vbulletin->GPC['serverfile']))
	{
		$xml = file_read($vbulletin->GPC['serverfile']);
	}
	// no uploaded file and no local file - ERROR
	else
	{
		print_stop_message('no_file_uploaded_and_no_local_file_found');
	}

	print_dots_start('<b>' . $vbphrase['importing_plugins'] . "</b>, $vbphrase[please_wait]", ':', 'dspan');

	require_once(DIR . '/includes/class_xml.php');

	$xmlobj = new vB_XML_Parser($xml);
	if ($xmlobj->error_no == 1)
	{
			print_dots_stop();
			print_stop_message('no_xml_and_no_path');
	}

	if(!$arr = $xmlobj->parse())
	{
		print_dots_stop();
		print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	}

	if (!$arr['plugin'])
	{
		print_dots_stop();
		if (!empty($arr['productid']))
		{
			print_stop_message('this_file_appears_to_be_a_product');
		}
		else
		{
			print_stop_message('invalid_file_specified');
		}
	}

	if (!is_array($arr['plugin'][0]))
	{
		$arr['plugin'] = array($arr['plugin']);
	}

	$maxid = $db->query_first("SELECT MAX(pluginid) AS max FROM " . TABLE_PREFIX . "plugin");

	foreach ($arr['plugin'] AS $plugin)
	{
		unset($plugin['devkey']); // make sure we don't try to set this as it's no longer used

		$db->query_write(fetch_query_sql($plugin, 'plugin'));
	}

	// rebuild the $vboptions array
	vBulletinHook::build_datastore($db);

	// stop the 'dots' counter feedback
	print_dots_stop();

	print_cp_redirect("apm_product.php?" . $vbulletin->session->vars['sessionurl'], 0);
}

// #############################################################################
if ($_POST['do'] == 'download')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'filename' => TYPE_STR,
		'download' => TYPE_ARRAY_UINT,
	));

	if (empty($vbulletin->GPC['download']) OR empty($vbulletin->GPC['filename']))
	{
		print_stop_message('please_complete_required_fields');
	}

	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_XML_Builder($vbulletin);
	$xml->add_group('plugins');

	$plugins = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "plugin WHERE pluginid IN (" . implode(', ', $vbulletin->GPC['download']) . ")");
	while ($plugin = $db->fetch_array($plugins))
	{
		$params = array('active' => $plugin['active'], 'executionorder' => $plugin['executionorder']);
		if ($plugin['product'])
		{
			$params['product'] = $plugin['product'];
		}

		$xml->add_group('plugin', $params);

		$xml->add_tag('title', $plugin['title']);
		$xml->add_tag('hookname', $plugin['hookname']);
		$xml->add_tag('phpcode', $plugin['phpcode']);

		$xml->close_group();
	}

	$xml->close_group();

	$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";

	$doc .= $xml->output();
	$xml = null;

	require_once(DIR . '/includes/functions_file.php');
	file_download($doc, $vbulletin->GPC['filename'], 'text/xml');
}

// #############################################################################

if ($_POST['do'] == 'updateactive')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'productid'		=> TYPE_STR,
		'active'			=> TYPE_ARRAY_UINT,
		'showplugins'	=> TYPE_UINT,
	));

	$cond = '';

	$plugins = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "plugin WHERE product = '" . $vbulletin->GPC['productid'] . "'");
	while ($plugin = $db->fetch_array($plugins))
	{
		$cond .= "WHEN $plugin[pluginid] THEN " . (isset($vbulletin->GPC['active']["$plugin[pluginid]"]) ? 1 : 0) . "\n";
	}

	if (!empty($cond))
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "plugin SET active = CASE pluginid
			$cond
			ELSE active END
		");
	}

	// update the datastore
	vBulletinHook::build_datastore($db);

	$_REQUEST['do'] = 'managedetails';
	$_REQUEST['productid'] = $vbulletin->GPC['productid'];
	$_REQURST['showplugins'] = $vbulletin->GPC['showplugins'];
}

// #############################################################################

if ($_POST['do'] == 'kill')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'showplugins'   => TYPE_UINT,
        ));

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE pluginid = " . $vbulletin->GPC['pluginid']);

	vBulletinHook::build_datastore($db);

	define('CP_REDIRECT', 'apm_product.php?do=managedetails&amp;productid=' . $vbulletin->GPC['productid'] . "&amp;showplugins=" . $vbulletin->GPC['showplugins']);
	print_stop_message('deleted_plugin_successfully');
}

// #############################################################################

if ($_REQUEST['do'] == 'delete')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'pluginid' => TYPE_UINT,
		'name'    => TYPE_STR,
		'productid'	=> TYPE_STR,
		'showplugins'	=> TYPE_UINT,
	));

	print_delete_confirmation('plugin', $vbulletin->GPC['pluginid'], 'apm_product', 'kill','',array('productid' => $vbulletin->GPC['productid'],'showplugins' => $vbulletin->GPC['showplugins']));
}

// #############################################################################
if ($_POST['do'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'hookname'       => TYPE_STR,
		'title'          => TYPE_STR,
		'phpcode'        => TYPE_STR,
		'active'         => TYPE_BOOL,
		'product'        => TYPE_STR,
		'executionorder' => TYPE_UINT,
		'showplugins'    => TYPE_UINT,
		'return'         => TYPE_STR,
	));

	if (!$vbulletin->GPC['hookname'] OR !$vbulletin->GPC['title'] OR !$vbulletin->GPC['phpcode'])
	{
		print_stop_message('please_complete_required_fields');
	}

	if ($vbulletin->GPC['pluginid'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "plugin
			SET
				hookname = '" . $db->escape_string($vbulletin->GPC['hookname']) . "',
				title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
				phpcode = '" . $db->escape_string($vbulletin->GPC['phpcode']) . "',
				product = '" . $db->escape_string($vbulletin->GPC['product']) . "',
				active = " . intval($vbulletin->GPC['active']) . ",
				executionorder = " . intval($vbulletin->GPC['executionorder']) . "
			WHERE pluginid = " . $vbulletin->GPC['pluginid'] . "
		");
	}
	else
	{
		/*insert query*/
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "plugin
				(hookname, title, phpcode, product, active, executionorder)
			VALUES
				('" . $db->escape_string($vbulletin->GPC['hookname']) . "',
				'" . $db->escape_string($vbulletin->GPC['title']) . "',
				'" . $db->escape_string($vbulletin->GPC['phpcode']) . "',
				'" . $db->escape_string($vbulletin->GPC['product']) . "',
				" . intval($vbulletin->GPC['active']) . ",
				" . intval($vbulletin->GPC['executionorder']) . ")
		");
		$vbulletin->GPC['pluginid'] = $db->insert_id();
	}

	// update the datastore
	vBulletinHook::build_datastore($db);

// stuff to handle the redirect
 if ($vbulletin->GPC['return'])
 {
	define('CP_REDIRECT', "apm_product.php?do=edit&amp;pluginid=" . $vbulletin->GPC['pluginid']);
 }
 else
 {
	define('CP_REDIRECT', 'apm_product.php?do=managedetails&amp;productid=' . $vbulletin->GPC['product'] . "&amp;showplugins=" . $vbulletin->GPC['showplugins']);
 }
	
	print_stop_message('saved_plugin_successfully');
}

// #############################################################################

if ($_REQUEST['do'] == 'edit' OR $_REQUEST['do'] == 'add')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'showplugins' => TYPE_UINT,
        ));


	$products = fetch_product_list();

	$hooklocations = array();
	require_once(DIR . '/includes/class_xml.php');
	$handle = opendir(DIR . '/includes/xml/');
	while (($file = readdir($handle)) !== false)
	{
		if (!preg_match('#^hooks_(.*).xml$#i', $file, $matches))
		{
			continue;
		}
		$product = $matches[1];

		$phrased_product = $products[($product ? $product : 'vbulletin')];
		if (!$phrased_product)
		{
			$phrased_product = $product;
		}

		$xmlobj = new vB_XML_Parser(false, DIR . "/includes/xml/$file");
		$xml = $xmlobj->parse();

		if (!is_array($xml['hooktype'][0]))
		{
			// ugly kludge but it works...
			$xml['hooktype'] = array($xml['hooktype']);
		}

		foreach ($xml['hooktype'] AS $key => $hooks)
		{
			if (!is_numeric($key))
			{
				continue;
			}
			$phrased_type = isset($vbphrase["hooktype_$hooks[type]"]) ? $vbphrase["hooktype_$hooks[type]"] : $hooks['type'];

			$hooktype = $phrased_product . ' : ' . $phrased_type;

			$hooklocations["$hooktype"] = array();

			if (!is_array($hooks['hook']))
			{
				$hooks['hook'] = array($hooks['hook']);
			}

			foreach ($hooks['hook'] AS $hook)
			{
				$hookid = trim(is_string($hook) ? $hook : $hook['value']);
				if ($hookid !== '')
				{
					$hooklocations["$hookid"] = $hookid . ($product != 'vbulletin' ? " ($phrased_product)" : '');
				}
			}
		}
	}
	uksort($hooklocations, 'strnatcasecmp');

	$plugin = $db->query_first("
		SELECT plugin.*,
			IF(product.productid IS NULL, 0, 1) AS foundproduct,
			IF(plugin.product = 'vbulletin', 1, product.active) AS productactive
		FROM " . TABLE_PREFIX . "plugin AS plugin
		LEFT JOIN " . TABLE_PREFIX . "product AS product ON(product.productid = plugin.product)
		WHERE pluginid = " . $vbulletin->GPC['pluginid']
	);
	if (!$plugin)
	{
		$plugin = array(
			'product'	=>	$vbulletin->GPC['productid'],
			'executionorder' => 5
		);
	}

	print_form_header('apm_product', 'update');
	construct_hidden_code('pluginid', $plugin['pluginid']);
	construct_hidden_code('showplugins', $vbulletin->GPC['showplugins']);

	if ($_REQUEST['do'] == 'add')
	{
		$heading = $vbphrase['add_new_plugin'];
	}
	else
	{
		$heading = construct_phrase($vbphrase['edit_plugin_x'], htmlspecialchars_uni($plugin['title']));
	}

	print_table_header($heading);

	print_select_row($vbphrase['product'], 'product', fetch_product_list(), $plugin['product'] ? $plugin['product'] : 'vbulletin');
	print_select_row("$vbphrase[hook_location] <dfn>$vbphrase[hook_location_desc]</dfn>",
		'hookname',
		array_merge(array('' => ''), $hooklocations),
		$plugin['hookname']
	);
	print_input_row("$vbphrase[title] <dfn>$vbphrase[plugin_title_desc]</dfn>", 'title', $plugin['title'], 1, 60);
	print_input_row("$vbphrase[plugin_execution_order] <dfn>$vbphrase[plugin_order_desc]</dfn>", 'executionorder', $plugin['executionorder'], 1, 10);
	print_textarea_row(
		"$vbphrase[plugin_php_code] <dfn>$vbphrase[plugin_code_desc]</dfn>",
		'phpcode',
		htmlspecialchars($plugin['phpcode']),
		10, '45" style="width:100%',
		false,
		true,
		'ltr',
		'code'
	);

	if ($plugin['foundproduct'] AND !$plugin['productactive'])
	{
		print_description_row(construct_phrase($vbphrase['plugin_inactive_due_to_product_disabled'], $products["$plugin[product]"]));
	}
	print_yes_no_row("$vbphrase[plugin_is_active] <dfn>$vbphrase[plugin_active_desc]</dfn>", 'active', $plugin['active']);
//print_submit_row($vbphrase['save'], $vbphrase['reset']);
	print_submit_row($vbphrase['save'], '_default_', 2, '', "<input type=\"submit\" class=\"button\" tabindex=\"1\" name=\"return\" value=\"$vbphrase[save_and_reload]\" accesskey=\"e\" />");  

	if ($plugin['phpcode'] != '')
	{
		// highlight the string
		$code = $plugin['phpcode'];

		// do we have an opening <? tag?
		if (!preg_match('#^\s*<\?#si', $code))
		{
			// if not, replace leading newlines and stuff in a <?php tag and a closing tag at the end
			$code = "<?php BEGIN__VBULLETIN__CODE__SNIPPET $code \r\nEND__VBULLETIN__CODE__SNIPPET ?>";
			$addedtags = true;
		}
		else
		{
			$addedtags = false;
		}

		// highlight the string
		$oldlevel = error_reporting(0);
		$code = highlight_string($code, true);
		error_reporting($oldlevel);

		// if we added tags above, now get rid of them from the resulting string
		if ($addedtags)
		{
			$search = array(
				'#(<|&lt;)\?php( |&nbsp;)BEGIN__VBULLETIN__CODE__SNIPPET( |&nbsp;)#siU',
				'#(<(span|font).*>)(<|&lt;)\?(</\\2>(<\\2.*>))php( |&nbsp;)BEGIN__VBULLETIN__CODE__SNIPPET( |&nbsp;)#siU',
				'#END__VBULLETIN__CODE__SNIPPET( |&nbsp;)\?(>|&gt;)#siU'
			);
			$replace = array(
				'',
				'\\5',
				''
			);
			$code = preg_replace($search, $replace, $code);
		}

		print_form_header('', '');
		print_table_header($vbphrase['plugin_php_code']);
		print_description_row("<div dir=\"ltr\">$code</div>");
		print_table_footer();
	}
}

// #############################################################################
// #############################################################################
// #############################################################################

if ($_REQUEST['do'] == 'product')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'sort'	=> TYPE_STR,
		'order'	=> TYPE_STR,
	));

	if (!$vbulletin->GPC['sort'])
	{
		$vbulletin->GPC['sort'] = "title";
	}
	if (!$vbulletin->GPC['order'])
	{
		$vbulletin->GPC['order'] = "asc";
	}

	if ($vbulletin->GPC['order'] == "asc") 
	{
		$order = "desc";
	}
	else
	{
		$order = "asc";
	}

	?>
	<script type="text/javascript">
	function js_page_jump(i, sid)
	{
		var sel = fetch_object("prodsel" + i);
		var act = sel.options[sel.selectedIndex].value;
		if (act != '')
		{
			switch (act)
			{
				case 'productadvancededit': page = "apm_product.php?do=managedetails&productid="; break;
				case 'productdisable': page = "apm_product.php?do=productdisable&productid="; break;
				case 'productenable': page = "apm_product.php?do=productenable&productid="; break;
				case 'productedit': page = "apm_product.php?do=productedit&productid="; break;
				case 'productversioncheck': page = "plugin.php?do=productversioncheck&productid="; break;
				case 'productexport': page = "apm_product.php?do=productexport&productid="; break;
				case 'productdelete': page = "apm_product.php?do=productdelete&productid="; break;
				default: return;
			}
			document.cpform.reset();
			jumptopage = page + sid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['invalid_action_specified']); ?>');
		}
	}
	
	function CheckAll(x) 
	{
		for(var i=0,l=x.form.length; i<l; i++)
		if(x.form[i].type == 'checkbox' && x.form[i].name != 'sAll')
		x.form[i].checked=true
	}
	function UnCheckAll(x) 
	{
		for(var i=0,l=x.form.length; i<l; i++)
		if(x.form[i].type == 'checkbox' && x.form[i].name != 'sAll')
		x.form[i].checked=false
	}
	function CheckReverse(x) 
	{
		for(var i=0,l=x.form.length; i<l; i++)
		if(x.form[i].type == 'checkbox' && x.form[i].name != 'sAll')
		x.form[i].checked=x.form[i].checked?false:true
	}

	</script>

	<?php

	print_form_header('apm_product', 'productstatuschange');
//	print_form_header('plugin', 'productexport', false, true, 'cpform', '90%', 'download');
//	construct_hidden_code('productid', '');

	print_table_header($vbphrase['installed_products'], 11); # Phrase me
	print_cells_row(array("<a href=\"?sort=title". iif($vbulletin->GPC['sort']=="title","&order=$order") ."\">$vbphrase[title]</a>", $vbphrase['version'], $vbphrase['description'],"<a href=\"?sort=apm_releasedate". iif($vbulletin->GPC['sort']=="apm_releasedate","&order=$order") ."\">$vbphrase[apm_releasedate]</a> <a href=\"?sort=apm_installdate". iif($vbulletin->GPC['sort']=="apm_installdate","&order=$order") ."\">$vbphrase[apm_installdate]</a>",$vbphrase['apm_plugins'],$vbphrase['phrases'],$vbphrase['template'],$vbphrase['setting'], $vbphrase['controls'],""), 1);

	print_cells_row(array('<strong>vBulletin</strong>', $vbulletin->options['templateversion'],'','', '', '', '', '', '',''), false, '', -2);
//	print_cells_row(array('<strong>vBulletin</strong>','vbulletin', $vbulletin->options['templateversion'],'', '', '', '', '', ''), false, '', -2);

	// used for <select> id attribute
	$i = 0;
  $start_disable_product = 0;
// get products information. count settings is comment out since it may take a long time. if you want to give it a try, uncomment two # on the query bellow


	$products = $db->query_read("
		SELECT * 
		FROM " . TABLE_PREFIX . "product
		ORDER BY active DESC, " . $vbulletin->GPC['sort'] ." " . $vbulletin->GPC['order'] . "
	");
   while ($product = $db->fetch_array($products))
    {
        $products2["$product[productid]"] = $product;
        $products2["$product[productid]"]['plugin'] = 0;
        $products2["$product[productid]"]['phrase'] = 0;
        $products2["$product[productid]"]['template'] = 0;
        $products2["$product[productid]"]['setting'] = 0;
    }

	$productlist = "'". implode('\',\'',array_keys($products2)) ."'";

    $pluginq = $db->query_read("SELECT product, COUNT(pluginid) AS plugin FROM " . TABLE_PREFIX . "plugin WHERE product IN ($productlist) GROUP BY product");
    while ($plugin = $db->fetch_array($pluginq))
    {
        $products2["$plugin[product]"]['plugin'] = $plugin['plugin'];
    }

    $phraseq = $db->query_read("SELECT product, COUNT(phraseid) AS phrase FROM " . TABLE_PREFIX . "phrase WHERE languageid=-1 AND product IN ($productlist) GROUP BY product");
    while ($phrase = $db->fetch_array($phraseq))
    {
        $products2["$phrase[product]"]['phrase'] = $phrase['phrase'];
    }

    $templateq = $db->query_read("SELECT product, COUNT(templateid) AS template FROM " . TABLE_PREFIX . "template WHERE styleid=-1 AND product IN ($productlist) GROUP BY product");
    while ($template = $db->fetch_array($templateq))
    {
        $products2["$template[product]"]['template'] = $template['template'];
    }
    
    $settingq = $db->query_read("SELECT product, COUNT(varname) AS setting FROM " . TABLE_PREFIX . "setting WHERE product IN ($productlist) GROUP BY product");
    while ($setting = $db->fetch_array($settingq))
    {
        $products2["$setting[product]"]['setting'] = $setting['setting'];
    }

    foreach ($products2 AS $product) 
	{
		$title = htmlspecialchars_uni($product['title']);
		if (!$product['active'])
		{
			$title = "<strike>$title</strike>";
		}
		if ($product['url'])
		{
			$title = '<a href="' . htmlspecialchars_uni($product['url']) . "\" target=\"_blank\">$title</a>";
		}

/*		$title =  htmlspecialchars_uni($product['title']);

		if (!$product['active'])
		{
			$title = "<font color=\"red\"><strike>$title</strike></font>";
		}
		if ($product['url'])
		{
			$title = '<a href="' . htmlspecialchars_uni($product['url']) . "\" target=\"_blank\" title=\"$product[productid]\">$title</a>";

		}
		else
		{
			$title = "<a title=\"$product[productid]\">$title</a>";
		}
*/ 

		if (!$product['active'] AND $start_disable_product == 0)
		{
			$start_disable_product = 1;
//			echo "</table><table>";
//			print_table_footer();
//			print_form_header('', '');
//			print_table_header("Disabled product", 11); # Phrase me
			print_cells_row(array("<a href=\"?sort=title". iif($vbulletin->GPC['sort']=="title","&order=$order") ."\">$vbphrase[title]</a>", $vbphrase['version'], $vbphrase['description'],"<a href=\"?sort=apm_releasedate". iif($vbulletin->GPC['sort']=="apm_releasedate","&order=$order") ."\">$vbphrase[apm_releasedate]</a> <a href=\"?sort=apm_installdate". iif($vbulletin->GPC['sort']=="apm_installdate","&order=$order") ."\">$vbphrase[apm_installdate]</a>",$vbphrase['apm_plugins'],$vbphrase['phrases'],$vbphrase['template'],$vbphrase['setting'], $vbphrase['controls'],""), 1);
		}

		$options= array();
		$options['productadvancededit'] = " ";
		$options['productedit'] = $vbphrase['edit'];
		if ($product['versioncheckurl'])
		{
			$options['productversioncheck'] = $vbphrase['check_version'];
		}
		if ($product['active'])
		{
			$options['productdisable'] = $vbphrase['disable'];
		}
		else
		{
			$options['productenable'] = $vbphrase['enable'];
		}
		$options['productexport'] = $vbphrase['export'];
		$options['productdelete'] = $vbphrase['uninstall'];

		$safeid = preg_replace('#[^a-z0-9_]#', '', $product['productid']);
		if (file_exists(DIR . '/includes/version_' . $safeid . '.php'))
		{
			include_once(DIR . '/includes/version_' . $safeid . '.php');
		}
		$define_name = 'FILE_VERSION_' . strtoupper($safeid);
		if (defined($define_name) AND constant($define_name) !== '')
		{
			$product['version'] = constant($define_name);
		}

//				$date = vbdate($vbulletin->options['dateformat'], $product['apm_installdate']);

		$i++;
		print_cells_row(array(
			$title,
			htmlspecialchars_uni($product['version']),
			htmlspecialchars_uni($product['description']),
			iif($product['apm_releasedate']," r".vbdate($vbulletin->options['dateformat'], $product['apm_releasedate'])) . iif($product['apm_installdate']," i".vbdate($vbulletin->options['dateformat'], $product['apm_installdate'])),
			"<a href=\"apm_product.php?do=managedetails&productid=$product[productid]&showplugins=1&s=".$vbulletin->session->vars[sessionhash]."\">" . $product['plugin'] ."</a>",
			"<a href=\"apm_product.php?do=managedetails&productid=$product[productid]&showphrases=1&s=".$vbulletin->session->vars[sessionhash]."\">" . $product['phrase'] ."</a>",
			"<a href=\"apm_product.php?do=managedetails&productid=$product[productid]&showtemplates=1&s=".$vbulletin->session->vars[sessionhash]."\">" . $product['template'] ."</a>",
			"<a href=\"apm_product.php?do=managedetails&productid=$product[productid]&showsettings=1&s=".$vbulletin->session->vars[sessionhash]."\">" . $product['setting'] ."</a>",
			"\n\t<select name=\"s$product[productid]\" id=\"prodsel$i\" onchange=\"js_page_jump($i, '$product[productid]')\" class=\"bginput\">\n" . construct_select_options($options) . "\t</select>&nbsp;<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_page_jump($i, '$product[productid]');\" />",
			"<input name=\"plist[$product[productid]]\" id=\"plist_$product[productid]\" ". iif($product[active],"checked") ." type=\"checkbox\">"
		), false, '', -2);
	}
	//construct_hidden_code('do', 'productstatuschange');
  print_description_row("<input type=\"button\" name=\"Check_All\" value=\" \" onClick=\"CheckAll(this)\"><input type=\"button\" name=\"Un_CheckAll\" value=\"  \" onClick=\"UnCheckAll(this)\"> <input type=\"button\" name=\"Reverse_Check\" value=\" \" onClick=\"CheckReverse(this)\">" . construct_button_code(""),0,11,"","right");
	print_submit_row("",0,11);

	print_table_footer();

	echo '<p align="center">' . construct_link_code($vbphrase['add_import_product'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=productadd") . '</p>';
}

// #############################################################################

if ($_REQUEST['do'] == 'productversioncheck')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid' => TYPE_STR
	));

	$product = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
	");

	if (!$product OR empty($product['versioncheckurl']))
	{
		print_stop_message('invalid_product_specified');
	}

	$version_url = @parse_url($product['versioncheckurl']);
	if (!$version_url)
	{
		print_stop_message('invalid_version_check_url_specified');
	}

	if (!$version_url['port'])
	{
		$version_url['port'] = 80;
	}
	if (!$version_url['path'])
	{
		$version_url['path'] = '/';
	}

	$fp = @fsockopen($version_url['host'], ($version_url['port'] ? $version_url['port'] : 80), $errno, $errstr, 10);
	if (!$fp)
	{
		print_stop_message('version_check_connect_failed_host_x_error_y',
			htmlspecialchars_uni($version_url['host']),
			htmlspecialchars_uni($errstr)
		);
	}

	$send_headers = "POST $version_url[path] HTTP/1.0\r\n";
	$send_headers .= "Host: $version_url[host]\r\n";
	$send_headers .= "User-Agent: vBulletin Product Version Check\r\n";
	if ($version_url['query'])
	{
		$send_headers .= "Content-Type: application/x-www-form-urlencoded\r\n";
	}
	$send_headers .= "Content-Length: " . strlen($version_url['query']) . "\r\n";
	$send_headers .= "\r\n";

	fwrite($fp, $send_headers . $version_url['query']);

	$full_result = '';
	while (!feof($fp))
	{
		$result = fgets($fp, 1024);
		$full_result .= $result;
	}

	fclose($fp);

	preg_match('#^(.*)\r\n\r\n(.*)$#sU', $full_result, $matches);
	$headers = trim($matches[1]);
	$body = trim($matches[2]);

	if (preg_match('#<version productid="' . preg_quote($product['productid'], '#') . '">(.+)</version>#iU', $body, $matches))
	{
		$latest_version = $matches[1];
	}
	else if (preg_match('#<version>(.+)</version>#iU', $body, $matches))
	{
		$latest_version = $matches[1];
	}
	else
	{
		print_stop_message('version_check_failed_not_found');
	}

	// see if we have a patch or something
	$safeid = preg_replace('#[^a-z0-9_]#', '', $product['productid']);
	if (file_exists(DIR . '/includes/version_' . $safeid . '.php'))
	{
		include_once(DIR . '/includes/version_' . $safeid . '.php');
	}
	$define_name = 'FILE_VERSION_' . strtoupper($safeid);
	if (defined($define_name) AND constant($define_name) !== '')
	{
		$product['version'] = constant($define_name);
	}

	print_form_header('', '');

	if (is_newer_version($latest_version, $product['version']))
	{
		print_table_header(construct_phrase($vbphrase['product_x_out_of_date'], htmlspecialchars_uni($product['title'])));
		print_label_row($vbphrase['installed_version'], htmlspecialchars_uni($product['version']));
		print_label_row($vbphrase['latest_version'], htmlspecialchars_uni($latest_version));
		if ($product['url'])
		{
			print_description_row(
				'<a href="' . htmlspecialchars_uni($product['url']) . '" target="_blank">' . $vbphrase['click_here_for_more_info'] . '</a>',
				false,
				2,
				'',
				'center'
			);
		}
	}
	else
	{
		print_table_header(construct_phrase($vbphrase['product_x_up_to_date'], htmlspecialchars_uni($product['title'])));
		print_label_row($vbphrase['installed_version'], htmlspecialchars_uni($product['version']));
		print_label_row($vbphrase['latest_version'], htmlspecialchars_uni($latest_version));
	}

	print_table_footer();
}

// #############################################################################

if ($_REQUEST['do'] == 'productdisable' OR $_REQUEST['do'] == 'productenable')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid' => TYPE_STR,
		'confirmswitch' => TYPE_BOOL
	));

	$product = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
	");

	if (!$product)
	{
		print_stop_message('invalid_product_specified');
	}

	$product_list = fetch_product_list(true);

	$dependency_result = $db->query_read("
		SELECT productid, parentproductid
		FROM " . TABLE_PREFIX . "productdependency
		WHERE dependencytype = 'product' AND parentproductid <> ''
	");

	if ($_REQUEST['do'] == 'productdisable')
	{
		$newstate = 0;

		// disabling a product -- disable all children

		// list with parents as keys, good for traversing downward
		$dependency_list = array();
		while ($dependency = $db->fetch_array($dependency_result))
		{
			$dependency_list["$dependency[parentproductid]"][] = $dependency['productid'];
		}

		$children = fetch_product_dependencies($vbulletin->GPC['productid'], $dependency_list);

		$need_switch = array();
		foreach ($children AS $childproductid)
		{
			$childproduct = $product_list["$childproductid"];
			if ($childproduct AND $childproduct['active'] == 1)
			{
				// product exists and is enabled -- needs to be disabled
				$need_switch[$db->escape_string("$childproductid")] = $childproduct['title'];
			}
		}

		$phrase_name = 'additional_products_disable_x_y';
	}
	else
	{
		$newstate = 1;

		// enabling a product -- enable all parents

		// list with children as keys, good for traversing upward
		$dependency_list = array();
		while ($dependency = $db->fetch_array($dependency_result))
		{
			$dependency_list["$dependency[productid]"][] = $dependency['parentproductid'];
		}

		$parents = fetch_product_dependencies($vbulletin->GPC['productid'], $dependency_list);

		$need_switch = array();
		foreach ($parents AS $parentproductid)
		{
			$parentproduct = $product_list["$parentproductid"];
			if ($parentproduct AND $childproduct['active'] == 0)
			{
				// product exists and is disabled -- needs to be enabled
				$need_switch[$db->escape_string("$parentproductid")] = $parentproduct['title'];
			}
		}

		$phrase_name = 'additional_products_enable_x_y';
	}

	if (!$vbulletin->GPC['confirmswitch'] AND count($need_switch) > 0)
	{
		// to do this, we need to update the status of some additional products,
		// so make sure the user knows what's going on
		$need_switch_str = '<li>' . implode('</li><li>', $need_switch) . '</li>';
		print_stop_message(
			$phrase_name,
			htmlspecialchars_uni($product['title']),
			$need_switch_str,
			'plugin.php?' . $vbulletin->session->vars['sessionurl'] .
				'do=' . urlencode($_REQUEST['do']) .
				'&amp;productid=' . urlencode($vbulletin->GPC['productid']) .
				'&amp;confirmswitch=1'
		);
	}

	// $need_switch is already escaped
	$product_update = array_keys($need_switch);
	$product_update[] = $db->escape_string($vbulletin->GPC['productid']);

	// Do the product table
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "product
		SET active = $newstate
		WHERE productid IN ('" . implode("', '", $product_update) . "')
	");

	vBulletinHook::build_datastore($db);
	build_product_datastore();

	// build bitfields to remove/add this products bitfields
	require_once(DIR . '/includes/class_bitfield_builder.php');
	vB_Bitfield_Builder::save($db);

	vB_Cache::instance()->purge('vb_types.types');

	// this could enable a cron entry, so we need to rebuild that as well
	require_once(DIR . '/includes/functions_cron.php');
	build_cron_next_run();

	define('CP_REDIRECT', 'index.php?loc=' . urlencode('apm_product.php?do=product'));

	if ($_REQUEST['do'] == 'productdisable')
	{
		print_stop_message('product_disabled_successfully');
	}
	else
	{
		print_stop_message('product_enabled_successfully');
	}
}
// #############################################################################
if ($_REQUEST['do'] == 'productstatuschange')
{
		$vbulletin->input->clean_array_gpc('r', array(
		'plist' => TYPE_ARRAY,
	));

//	print_r($vbulletin->GPC[plist]);
	
	$products = $db->query_read("
		SELECT * 
		FROM " . TABLE_PREFIX . "product
		ORDER BY active DESC
	");
	while ($product = $db->fetch_array($products))
	{
//		echo $vbulletin->GPC[plist][$product[productid]] . " -- ". $product[productid];
		if (!$vbulletin->GPC[plist][$product[productid]] )
		{
			if ($product[active])
			{
				echo " -- $product[active] -- no<br>";
				productstatuschange($product[productid],"productdisable");
			}
		}
		else
		{
			if (!$product[active])
			{
				echo " -- $product[active] -- yes<br>";
				productstatuschange($product[productid],"productenable");
			}
		}
	}

	define('CP_REDIRECT', 'apm_product.php?do=product');
	print_stop_message('product_enabled_successfully');
}

function productstatuschange($productid, $status, $confirmswitch=0)
{
	global $db;
	
	$productid = $db->escape_string($productid);
	
	$vbulletin->GPC['productid'] = $productid;
	$vbulletin->GPC['confirmswitch'] = $confirmswitch;
//	$vbulletin->db->query_write
	
	$product = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
	");

	if (!$product)
	{
		print_stop_message('invalid_product_specified');
	}

	$product_list = fetch_product_list(true);

	$dependency_result = $db->query_read("
		SELECT productid, parentproductid
		FROM " . TABLE_PREFIX . "productdependency
		WHERE dependencytype = 'product' AND parentproductid <> ''
	");

	if ($status == 'productdisable')
	{
		$newstate = 0;

		// disabling a product -- disable all children

		// list with parents as keys, good for traversing downward
		$dependency_list = array();
		while ($dependency = $db->fetch_array($dependency_result))
		{
			$dependency_list["$dependency[parentproductid]"][] = $dependency['productid'];
		}

		$children = fetch_product_dependencies($vbulletin->GPC['productid'], $dependency_list);

		$need_switch = array();
		foreach ($children AS $childproductid)
		{
			$childproduct = $product_list["$childproductid"];
			if ($childproduct AND $childproduct['active'] == 1)
			{
				// product exists and is enabled -- needs to be disabled
				$need_switch[$db->escape_string("$childproductid")] = $childproduct['title'];
			}
		}

		$phrase_name = 'additional_products_disable_x_y';
	}
	else
	{
		$newstate = 1;

		// enabling a product -- enable all parents

		// list with children as keys, good for traversing upward
		$dependency_list = array();
		while ($dependency = $db->fetch_array($dependency_result))
		{
			$dependency_list["$dependency[productid]"][] = $dependency['parentproductid'];
		}

		$parents = fetch_product_dependencies($vbulletin->GPC['productid'], $dependency_list);

		$need_switch = array();
		foreach ($parents AS $parentproductid)
		{
			$parentproduct = $product_list["$parentproductid"];
			if ($parentproduct AND $childproduct['active'] == 0)
			{
				// product exists and is disabled -- needs to be enabled
				$need_switch[$db->escape_string("$parentproductid")] = $parentproduct['title'];
			}
		}

		$phrase_name = 'additional_products_enable_x_y';
	}

	if (!$vbulletin->GPC['confirmswitch'] AND count($need_switch) > 0)
	{
		// to do this, we need to update the status of some additional products,
		// so make sure the user knows what's going on
		$need_switch_str = '<li>' . implode('</li><li>', $need_switch) . '</li>';
		print_stop_message(
			$phrase_name,
			htmlspecialchars_uni($product['title']),
			$need_switch_str,
			'plugin.php?' . $vbulletin->session->vars['sessionurl'] .
				'do=' . urlencode($_REQUEST['do']) .
				'&amp;productid=' . urlencode($vbulletin->GPC['productid']) .
				'&amp;confirmswitch=1'
		);
	}

	// $need_switch is already escaped
	$product_update = array_keys($need_switch);
	$product_update[] = $db->escape_string($vbulletin->GPC['productid']);

	// Do the product table
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "product
		SET active = $newstate
		WHERE productid IN ('" . implode("', '", $product_update) . "')
	");

	vBulletinHook::build_datastore($db);
	build_product_datastore();

	// build bitfields to remove/add this products bitfields
	require_once(DIR . '/includes/class_bitfield_builder.php');
	vB_Bitfield_Builder::save($db);

	// this could enable a cron entry, so we need to rebuild that as well
	require_once(DIR . '/includes/functions_cron.php');
	build_cron_next_run();
}


if ($_REQUEST['do'] == 'productstatuschange2')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid' => TYPE_STR,
		'confirmswitch' => TYPE_BOOL
	));

	$product = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
	");

	if (!$product)
	{
		print_stop_message('invalid_product_specified');
	}

	$product_list = fetch_product_list(true);

	$dependency_result = $db->query_read("
		SELECT productid, parentproductid
		FROM " . TABLE_PREFIX . "productdependency
		WHERE dependencytype = 'product' AND parentproductid <> ''
	");

	if ($_REQUEST['do'] == 'productdisable')
	{
		$newstate = 0;

		// disabling a product -- disable all children

		// list with parents as keys, good for traversing downward
		$dependency_list = array();
		while ($dependency = $db->fetch_array($dependency_result))
		{
			$dependency_list["$dependency[parentproductid]"][] = $dependency['productid'];
		}

		$children = fetch_product_dependencies($vbulletin->GPC['productid'], $dependency_list);

		$need_switch = array();
		foreach ($children AS $childproductid)
		{
			$childproduct = $product_list["$childproductid"];
			if ($childproduct AND $childproduct['active'] == 1)
			{
				// product exists and is enabled -- needs to be disabled
				$need_switch[$db->escape_string("$childproductid")] = $childproduct['title'];
			}
		}

		$phrase_name = 'additional_products_disable_x_y';
	}
	else
	{
		$newstate = 1;

		// enabling a product -- enable all parents

		// list with children as keys, good for traversing upward
		$dependency_list = array();
		while ($dependency = $db->fetch_array($dependency_result))
		{
			$dependency_list["$dependency[productid]"][] = $dependency['parentproductid'];
		}

		$parents = fetch_product_dependencies($vbulletin->GPC['productid'], $dependency_list);

		$need_switch = array();
		foreach ($parents AS $parentproductid)
		{
			$parentproduct = $product_list["$parentproductid"];
			if ($parentproduct AND $childproduct['active'] == 0)
			{
				// product exists and is disabled -- needs to be enabled
				$need_switch[$db->escape_string("$parentproductid")] = $parentproduct['title'];
			}
		}

		$phrase_name = 'additional_products_enable_x_y';
	}

	if (!$vbulletin->GPC['confirmswitch'] AND count($need_switch) > 0)
	{
		// to do this, we need to update the status of some additional products,
		// so make sure the user knows what's going on
		$need_switch_str = '<li>' . implode('</li><li>', $need_switch) . '</li>';
		print_stop_message(
			$phrase_name,
			htmlspecialchars_uni($product['title']),
			$need_switch_str,
			'plugin.php?' . $vbulletin->session->vars['sessionurl'] .
				'do=' . urlencode($_REQUEST['do']) .
				'&amp;productid=' . urlencode($vbulletin->GPC['productid']) .
				'&amp;confirmswitch=1'
		);
	}

	// $need_switch is already escaped
	$product_update = array_keys($need_switch);
	$product_update[] = $db->escape_string($vbulletin->GPC['productid']);

	// Do the product table
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "product
		SET active = $newstate
		WHERE productid IN ('" . implode("', '", $product_update) . "')
	");

	vBulletinHook::build_datastore($db);
	build_product_datastore();

	// build bitfields to remove/add this products bitfields
	require_once(DIR . '/includes/class_bitfield_builder.php');
	vB_Bitfield_Builder::save($db);

	// this could enable a cron entry, so we need to rebuild that as well
	require_once(DIR . '/includes/functions_cron.php');
	build_cron_next_run();

	define('CP_REDIRECT', 'apm_product.php?do=product');

	if ($_REQUEST['do'] == 'productdisable')
	{
		print_stop_message('product_disabled_successfully');
	}
	else
	{
		print_stop_message('product_enabled_successfully');
	}
}
// #############################################################################

if ($_REQUEST['do'] == 'productadd' OR $_REQUEST['do'] == 'productedit')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid'		=> TYPE_STR
	));

	if ($vbulletin->GPC['productid'])
	{
		$product = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "product
			WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
		");
	}
	else
	{
		$product = array();
	}

	if (!$product)
	{
		?>
		<script type="text/javascript">
		<!--
		function js_confirm_upload(tform, filefield)
		{
			if (filefield.value == "")
			{
				return confirm("<?php echo construct_phrase($vbphrase['you_did_not_specify_a_file_to_upload'], '" + tform.serverfile.value + "'); ?>");
			}
			return true;
		}
		//-->
		</script>
		<?php

		print_form_header('apm_product', 'productimport', 1, 1, 'uploadform" onsubmit="return js_confirm_upload(this, this.productfile);');
		print_table_header($vbphrase['import_product']);
		print_upload_row($vbphrase['upload_xml_file'], 'productfile', 999999999);
		print_input_row($vbphrase['import_xml_file'], 'serverfile', './includes/xml/product.xml');
		print_yes_no_row($vbphrase['allow_overwrite_upgrade_product'], 'allowoverwrite', 0);
		print_submit_row($vbphrase['import']);
	}

	print_form_header('apm_product', 'productsave');

	if ($product)
	{
		print_table_header(construct_phrase($vbphrase['edit_product_x'], $product['productid']));
		print_label_row($vbphrase['product_id'], $product['productid']);

		construct_hidden_code('productid', $product['productid']);
		construct_hidden_code('editing', 1);
	}
	else
	{
		print_table_header($vbphrase['add_new_product']);
		print_input_row($vbphrase['product_id'], 'productid', '', true, 50, 25); // max length = 25
	}

	print_input_row($vbphrase['title'], 'title', $product['title'], true, 50, 50);
	print_input_row($vbphrase['version'], 'version', $product['version'], true, 50, 25);
	print_input_row($vbphrase['description'], 'description', $product['description'], true, 50, 250);
	print_input_row($vbphrase['product_url'], 'url', $product['url'], true, 50, 250);
	print_input_row($vbphrase['version_check_url'], 'versioncheckurl', $product['versioncheckurl'], true, 50, 250);

	print_submit_row();

	// if we're editing a product, show the install/uninstall code options
	if ($product)
	{
		echo '<hr />';

		print_form_header('apm_product', 'productdependency');
		construct_hidden_code('productid', $vbulletin->GPC['productid']);

		// the <label> tags in the product type are for 3.6 bug 349
		$dependency_types = array(
			'php'       => $vbphrase['php_version'],
			'mysql'     => $vbphrase['mysql_version'],
			'vbulletin' => $vbphrase['vbulletin_version'],
			'product'   => $vbphrase['product_id'] . '</label>&nbsp;<input type="text" class="bginput" name="parentproductid" id="it_parentproductid" value="" size="15" maxlength="25" tabindex="1" /><label>',
		);

		$product_dependencies = $db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "productdependency
			WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			ORDER BY dependencytype, parentproductid, minversion
		");

		if ($db->num_rows($product_dependencies))
		{
			print_table_header($vbphrase['existing_product_dependencies'], 4);
			print_cells_row(array(
				$vbphrase['dependency_type'],
				$vbphrase['compatibility_starts'],
				$vbphrase['incompatible_with'],
				$vbphrase['delete']
			), 1);

			while ($product_dependency = $db->fetch_array($product_dependencies))
			{
				if ($product_dependency['dependencytype'] != 'product')
				{
					$dep_type = $dependency_types["$product_dependency[dependencytype]"];
				}
				else
				{
					$dep_type = $vbphrase['product'] . ' - ' . htmlspecialchars_uni($product_dependency['parentproductid']);
				}

				$depid = $product_dependency['productdependencyid'];

				print_cells_row(array(
					$dep_type,
					"<input type=\"text\" name=\"productdependency[$depid][minversion]\" value=\"" . htmlspecialchars_uni($product_dependency['minversion']) . "\" size=\"25\" maxlength=\"50\" tabindex=\"1\" />",
					"<input type=\"text\" name=\"productdependency[$depid][maxversion]\" value=\"" . htmlspecialchars_uni($product_dependency['maxversion']) . "\" size=\"25\" maxlength=\"50\" tabindex=\"1\" />",
					"<input type=\"checkbox\" name=\"productdependency[$depid][delete]\" value=\"1\" />"
				));
			}

			print_table_break();
		}

		print_table_header($vbphrase['add_new_product_dependency']);
		print_radio_row($vbphrase['dependency_type'], 'dependencytype', $dependency_types);
		print_input_row($vbphrase['compatibility_starts_with_version'], 'minversion', '', true, 25, 50);
		print_input_row($vbphrase['incompatible_with_version_and_newer'], 'maxversion', '', true, 25, 50);

		print_submit_row();

		// #############################################
		echo '<hr />';
		print_form_header('apm_product', 'productcode');
		construct_hidden_code('productid', $vbulletin->GPC['productid']);

		$productcodes = $db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "productcode
			WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			ORDER BY version
		");

		if ($db->num_rows($productcodes))
		{
			print_table_header($vbphrase['existing_install_uninstall_code'], 4);
			print_cells_row(array(
				$vbphrase['version'],
				$vbphrase['install_code'],
				$vbphrase['uninstall_code'],
				$vbphrase['delete']
			), 1);

			$productcodes_grouped = array();
			$productcodes_versions = array();

			while ($productcode = $db->fetch_array($productcodes))
			{
				// have to be careful here, as version numbers are not necessarily unique
				$productcodes_versions["$productcode[version]"] = 1;
				$productcodes_grouped["$productcode[version]"][] = $productcode;
			}

			$productcodes_versions = array_keys($productcodes_versions);
			usort($productcodes_versions, 'version_sort');

			foreach ($productcodes_versions AS $version)
			{
				foreach ($productcodes_grouped["$version"] AS $productcode)
				{
					print_cells_row(array(
						"<input type=\"text\" name=\"productcode[$productcode[productcodeid]][version]\" value=\"" . htmlspecialchars_uni($productcode['version']) . "\" style=\"width:100%\" size=\"10\" />",
						"<textarea name=\"productcode[$productcode[productcodeid]][installcode]\" rows=\"5\" cols=\"40\" style=\"width:100%\" wrap=\"virtual\" tabindex=\"1\">" . htmlspecialchars($productcode['installcode']) . "</textarea>",
						"<textarea name=\"productcode[$productcode[productcodeid]][uninstallcode]\" rows=\"5\" cols=\"40\" style=\"width:100%\" wrap=\"virtual\" tabindex=\"1\">" . htmlspecialchars($productcode['uninstallcode']) . "</textarea>",
						"<input type=\"checkbox\" name=\"productcode[$productcode[productcodeid]][delete]\" value=\"1\" />"
					));
				}
			}

			print_table_break();
		}

		print_table_header($vbphrase['add_new_install_uninstall_code']);

		print_input_row($vbphrase['version'], 'version');
		print_textarea_row($vbphrase['install_code'], 'installcode', '', 5, '70" style="width:100%');
		print_textarea_row($vbphrase['uninstall_code'], 'uninstallcode', '', 5, '70" style="width:100%');

		print_submit_row();
	}
}

// #############################################################################

if ($_POST['do'] == 'productsave')
{
	// Check to see if it is a duplicate.
	$vbulletin->input->clean_array_gpc('p', array(
		'productid'       => TYPE_STR,
		'editing'         => TYPE_BOOL,
		'title'           => TYPE_STR,
		'version'         => TYPE_STR,
		'description'     => TYPE_STR,
		'url'             => TYPE_STR,
		'versioncheckurl' => TYPE_STR,
		'confirm'         => TYPE_BOOL,
		'apm_releasedate' => TYPE_ARRAY, 
		'apm_author'   		=> TYPE_STR,
		'apm_relatedurl' 	=> TYPE_STR,
		'apm_extrainfo'  	=> TYPE_STR,
		'apm_extraedit'  	=> TYPE_STR,
		'apm_installdate'	=> TYPE_ARRAY,
	));
	$vbulletin->GPC['apm_releasedate'] = @mktime(1, 0, 0, $vbulletin->GPC['apm_releasedate']['month'], $vbulletin->GPC['apm_releasedate']['day'], $vbulletin->GPC['apm_releasedate']['year']);
	$vbulletin->GPC['apm_installdate'] = @mktime($vbulletin->GPC['apm_installdate']['hour'], $vbulletin->GPC['apm_installdate']['minute'], 0, $vbulletin->GPC['apm_installdate']['month'], $vbulletin->GPC['apm_installdate']['day'], $vbulletin->GPC['apm_installdate']['year']);

//	if ($vbulletin->GPC['apm_installdate'] == 0)
//	{
//		$vbulletin->GPC['apm_installdate'] = TIMENOW;
//	}
	
	if ($vbulletin->GPC['url'] AND !preg_match('#^[a-z0-9]+:#i', $vbulletin->GPC['url']))
	{
		$vbulletin->GPC['url'] = 'http://' . $vbulletin->GPC['url'];
	}
	if ($vbulletin->GPC['versioncheckurl'] AND !preg_match('#^[a-z0-9]+:#i', $vbulletin->GPC['versioncheckurl']))
	{
		$vbulletin->GPC['versioncheckurl'] = 'http://' . $vbulletin->GPC['versioncheckurl'];
	}

	if (!$vbulletin->GPC['productid'] OR !$vbulletin->GPC['title'] OR !$vbulletin->GPC['version'])
	{
		print_stop_message('please_complete_required_fields');
	}

	if (strtolower($vbulletin->GPC['productid']) == 'vbulletin')
	{
		print_stop_message('product_x_installed_version_y_z', 'vBulletin', $vbulletin->options['templateversion'], $vbulletin->GPC['version']);
	}

	if (!$vbulletin->GPC['editing'] AND $existingprod = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'"
	))
	{
		print_stop_message('product_x_installed_version_y_z', $vbulletin->GPC['title'], $existingprod['version'], $vbulletin->GPC['version']);
	}

//	require_once(DIR . '/includes/adminfunctions_template.php');

	$invalid_version_structure = array(0, 0, 0, 0, 0, 0);
	if (fetch_version_array($vbulletin->GPC['version']) == $invalid_version_structure)
	{
		print_stop_message('invalid_product_version');
	}

	if ($vbulletin->GPC['editing'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "product SET
				title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
				description = '" . $db->escape_string($vbulletin->GPC['description']) . "',
				version = '" . $db->escape_string($vbulletin->GPC['version']) . "',
				apm_releasedate = '" . $db->escape_string($vbulletin->GPC['apm_releasedate']) . "',
				apm_author = '" . $db->escape_string($vbulletin->GPC['apm_author']) . "',
				apm_relatedurl = '" . $db->escape_string($vbulletin->GPC['apm_relatedurl']) . "',
				apm_extrainfo = '" . $db->escape_string($vbulletin->GPC['apm_extrainfo']) . "',
				apm_extraedit = '" . $db->escape_string($vbulletin->GPC['apm_extraedit']) . "',
				apm_installdate = '" . $db->escape_string($vbulletin->GPC['apm_installdate']) . "',
				url = '" . $db->escape_string($vbulletin->GPC['url']) . "',
				versioncheckurl = '" . $db->escape_string($vbulletin->GPC['versioncheckurl']) . "'
			WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
		");
	}
	else
	{
		// product IDs must match #^[a-z0-9_]+$# and must be max 25 chars
		if (!preg_match('#^[a-z0-9_]+$#s', $vbulletin->GPC['productid']) OR strlen($vbulletin->GPC['productid']) > 25)
		{
			$sugg = preg_replace('#\s+#s', '_', strtolower($vbulletin->GPC['productid']));
			$sugg = preg_replace('#[^\w]#s', '', $sugg);
			$sugg = str_replace('__', '_', $sugg);
			$sugg = substr($sugg, 0, 25);
			print_stop_message('product_id_invalid', htmlspecialchars_uni($vbulletin->GPC['productid']), $sugg);
		}

		// reserve 'vb' prefix for official vBulletin products
		if (!$vbulletin->GPC['confirm'] AND strtolower(substr($vbulletin->GPC['productid'], 0, 2)) == 'vb')
		{
			print_form_header('apm_product', 'productsave');
			print_table_header($vbphrase['vbulletin_message']);
			print_description_row(
				htmlspecialchars_uni($vbulletin->GPC['title']) . ' ' . htmlspecialchars_uni($vbulletin->GPC['version']) .
				'<dfn>' . htmlspecialchars_uni($vbulletin->GPC['description']) . '</dfn>'
			);
			print_input_row($vbphrase['vb_prefix_reserved'], 'productid', $vbulletin->GPC['productid'], true, 35, 25);
			construct_hidden_code('title', $vbulletin->GPC['title']);
			construct_hidden_code('description', $vbulletin->GPC['description']);
			construct_hidden_code('version', $vbulletin->GPC['version']);
			construct_hidden_code('confirm', 1);
			print_submit_row();
			print_cp_footer();

			// execution terminates here
		}

		/* insert query */
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "product
				(productid, title, description, version, active, url, versioncheckurl, apm_installdate)
			VALUES
				('" . $db->escape_string($vbulletin->GPC['productid']) . "',
				'" . $db->escape_string($vbulletin->GPC['title']) . "',
				'" . $db->escape_string($vbulletin->GPC['description']) . "',
				'" . $db->escape_string($vbulletin->GPC['version']) . "',
				1,
				'" . $db->escape_string($vbulletin->GPC['url']) . "',
				'" . $db->escape_string($vbulletin->GPC['versioncheckurl']) . "',
				" . TIMENOW . "
				)
		");
	}

	// update the products datastore
	build_product_datastore();

	define('CP_REDIRECT', 'apm_product.php?do=managedetails&amp;productid=' . $vbulletin->GPC['productid']);
	print_stop_message('product_x_updated', $vbulletin->GPC['productid']);
}

// #############################################################################

if ($_POST['do'] == 'productdependency')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'productid'			=> TYPE_STR,
		'dependencytype'	=> TYPE_STR,
		'parentproductid'	=> TYPE_STR,
		'minversion'		=> TYPE_STR,
		'maxversion'		=> TYPE_STR,
		'productdependency'	=> TYPE_ARRAY
	));

	$product = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
	");

	if (!$product)
	{
		print_stop_message('invalid_product_specified');
	}

	if ($vbulletin->GPC['dependencytype'] != 'product')
	{
		$vbulletin->GPC['parentproductid'] = '';
	}

	if ($vbulletin->GPC['dependencytype'] OR $vbulletin->GPC['parentproductid'])
	{
		if ($vbulletin->GPC['minversion'] OR $vbulletin->GPC['maxversion'])
		{
			/* insert query */
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "productdependency
					(productid, dependencytype, parentproductid, minversion, maxversion)
				VALUES
					('" . $db->escape_string($vbulletin->GPC['productid']) . "',
					'" . $db->escape_string($vbulletin->GPC['dependencytype']) . "',
					'" . $db->escape_string($vbulletin->GPC['parentproductid']) . "',
					'" . $db->escape_string($vbulletin->GPC['minversion']) . "',
					'" . $db->escape_string($vbulletin->GPC['maxversion']) . "')
			");
		}
		else
		{
			print_stop_message('please_complete_required_fields');
		}
	}

	foreach ($vbulletin->GPC['productdependency'] AS $productdependencyid => $product_dependency)
	{
		$productdependencyid = intval($productdependencyid);

		if ($product_dependency['delete'])
		{
			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "productdependency
				WHERE productdependencyid = $productdependencyid
			");
		}
		else
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "productdependency SET
					minversion = '" . $db->escape_string($product_dependency['minversion']) . "',
					maxversion = '" . $db->escape_string($product_dependency['maxversion']) . "'
				WHERE productdependencyid = $productdependencyid
			");
		}
	}

	define('CP_REDIRECT', 'apm_product.php?do=managedetails&productid=' . $vbulletin->GPC['productid']);
	print_stop_message('product_x_updated', $vbulletin->GPC['productid']);
}

// #############################################################################

if ($_POST['do'] == 'productcode')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'productid'		=> TYPE_STR,
		'version'		=> TYPE_STR,
		'installcode'	=> TYPE_STR,
		'uninstallcode'	=> TYPE_STR,
		'productcode'	=> TYPE_ARRAY
	));

	$product = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
	");

	if (!$product)
	{
		print_stop_message('invalid_product_specified');
	}

	if ($vbulletin->GPC['version'] AND ($vbulletin->GPC['installcode'] OR $vbulletin->GPC['uninstallcode']))
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "productcode
				(productid, version, installcode, uninstallcode)
			VALUES
				('" . $db->escape_string($vbulletin->GPC['productid']) . "',
				'" . $db->escape_string($vbulletin->GPC['version']) . "',
				'" . $db->escape_string($vbulletin->GPC['installcode']) . "',
				'" . $db->escape_string($vbulletin->GPC['uninstallcode']) . "')
		");
	}

	foreach ($vbulletin->GPC['productcode'] AS $productcodeid => $productcode)
	{
		$productcodeid = intval($productcodeid);

		if ($productcode['delete'])
		{
			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "productcode
				WHERE productcodeid = $productcodeid
			");
		}
		else
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "productcode SET
					version = '" . $db->escape_string($productcode['version']) . "',
					installcode = '" . $db->escape_string($productcode['installcode']) . "',
					uninstallcode = '" . $db->escape_string($productcode['uninstallcode']) . "'
				WHERE productcodeid = $productcodeid
			");
		}
	}

	define('CP_REDIRECT', 'apm_product.php?do=managedetails&productid=' . $vbulletin->GPC['productid']);
	print_stop_message('product_x_updated', $vbulletin->GPC['productid']);
}

// #############################################################################

if ($_POST['do'] == 'productkill')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'productid' => TYPE_STR
	));
	if (strtolower($vbulletin->GPC['productid']) == 'vbulletin')
	{
		print_cp_redirect('apm_product.php');
	}

	$safe_productid = $db->escape_string($vbulletin->GPC['productid']);
	// run uninstall code first; try to undo things in the opposite order they were done
	$productcodes = $db->query_read("
		SELECT version, uninstallcode
		FROM " . TABLE_PREFIX . "productcode
		WHERE productid = '$safe_productid'
			AND uninstallcode <> ''
	");

	$productcodes_grouped = array();
	$productcodes_versions = array();

	while ($productcode = $db->fetch_array($productcodes))
	{
		// have to be careful here, as version numbers are not necessarily unique
		$productcodes_versions["$productcode[version]"] = 1;
		$productcodes_grouped["$productcode[version]"][] = $productcode;
	}

	unset($productcodes_versions['*']);
	$productcodes_versions = array_keys($productcodes_versions);
	usort($productcodes_versions, 'version_sort');
	$productcodes_versions = array_reverse($productcodes_versions);
	if (!empty($productcodes_grouped['*']))
	{
		// run * entries first
		foreach ($productcodes_grouped['*'] AS $productcode)
		{
			eval($productcode['uninstallcode']);
		}
	}

	foreach ($productcodes_versions AS $version)
	{
		foreach ($productcodes_grouped["$version"] AS $productcode)
		{
			eval($productcode['uninstallcode']);
		}
	}

	//remove some common resources that a product may have registered.
	//tags
	$db->query_write("
		DELETE tagcontent
		FROM " . TABLE_PREFIX . "package AS package JOIN
			" . TABLE_PREFIX . "contenttype AS contenttype ON
				contenttype.packageid = package.packageid JOIN
			" . TABLE_PREFIX . "tagcontent AS tagcontent ON
				contenttype.contenttypeid = tagcontent.contenttypeid
		WHERE productid = '$safe_productid'
	");

	// Packages, routes, actions, contenttypes
	$db->query_write("
		DELETE package, route, action, contenttype
		FROM " . TABLE_PREFIX . "package AS package
		LEFT JOIN " . TABLE_PREFIX . "route AS route
			ON route.packageid = package.packageid
		LEFT JOIN " . TABLE_PREFIX . "action AS action
			ON action.routeid = route.routeid
		LEFT JOIN " . TABLE_PREFIX . "contenttype AS contenttype
			ON contenttype.packageid = package.packageid
		WHERE productid = '$safe_productid'
	");

	// Clear routes from datastore

	$db->query_write("

		DELETE FROM " . TABLE_PREFIX . "datastore

		WHERE title = 'routes'

	");

	//clear the type cache.
	vB_Cache::instance()->purge('vb_types.types');

	// need to remove the language columns for this product as well
	require_once(DIR . '/includes/class_dbalter.php');

	$db_alter = new vB_Database_Alter_MySQL($db);
	if ($db_alter->fetch_table_info('language'))
	{
		$phrasetypes = $db->query_read("
			SELECT fieldname
			FROM " . TABLE_PREFIX . "phrasetype
			WHERE product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
		");
		while ($phrasetype = $db->fetch_array($phrasetypes))
		{
			$db_alter->drop_field("phrasegroup_$phrasetype[fieldname]");
		}
	}

	delete_product($vbulletin->GPC['productid']);

	build_all_styles();

	vBulletinHook::build_datastore($db);

	require_once(DIR . '/includes/adminfunctions_language.php');
	build_language();

	build_options();

	require_once(DIR . '/includes/functions_cron.php');
	build_cron_next_run();
	build_product_datastore();

	// build bitfields to remove/add this products bitfields
	require_once(DIR . '/includes/class_bitfield_builder.php');
	vB_Bitfield_Builder::save($db);
	if (!defined('DISABLE_PRODUCT_REDIRECT'))
	{
		define('CP_REDIRECT', 'index.php?loc=' . urlencode('apm_product.php?do=product'));
	}
	print_stop_message('product_x_uninstalled', $vbulletin->GPC['productid']);
}

// #############################################################################

if ($_REQUEST['do'] == 'productdelete')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid' => TYPE_STR
	));

	if (strtolower($vbulletin->GPC['productid']) == 'vbulletin')
	{
		print_cp_redirect('apm_product.php?do=product');
	}

	$dependency_result = $db->query_read("
		SELECT productid, parentproductid
		FROM " . TABLE_PREFIX . "productdependency
		WHERE dependencytype = 'product' AND parentproductid <> ''
	");

	// find child products -- these may break if we uninstall this
	$dependency_list = array();
	while ($dependency = $db->fetch_array($dependency_result))
	{
		$dependency_list["$dependency[parentproductid]"][] = $dependency['productid'];
	}

	$children = fetch_product_dependencies($vbulletin->GPC['productid'], $dependency_list);

	$product_list = fetch_product_list(true);

	$children_text = array();
	foreach ($children AS $childproductid)
	{
		$childproduct = $product_list["$childproductid"];
		if ($childproduct)
		{
			$children_text[] = $childproduct['title'];
		}
	}

	if ($children_text)
	{
		$affected_children = construct_phrase(
			$vbphrase['uninstall_product_break_products_x'],
			'<li>' . implode('</li><li>', $children_text) . '</li>'
		);
	}
	else
	{
		$affected_children = '';
	}
	print_delete_confirmation(
		'product',
		$vbulletin->GPC['productid'],
		'apm_product',
		'productkill',
		'',
		0,
		$affected_children
	);
}

// #############################################################################

if ($_POST['do'] == 'productimport')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'serverfile'   => TYPE_STR,
		'allowoverwrite' => TYPE_BOOL
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'productfile' => TYPE_FILE
	));

	if (file_exists($vbulletin->GPC['productfile']['tmp_name']))
	{
		// got an uploaded file?
		$xml = file_read($vbulletin->GPC['productfile']['tmp_name']);
	}
	else if (file_exists($vbulletin->GPC['serverfile']))
	{
		// no uploaded file - got a local file?
		$xml = file_read($vbulletin->GPC['serverfile']);
	}
	else
	{
		print_stop_message('no_file_uploaded_and_no_local_file_found');
	}

	try
	{
 		$info = install_product($xml, $vbulletin->GPC['allowoverwrite']);
	}
	catch (vB_Exception_AdminStopMessage $e)
	{
		//move print_stop_message calls from install_product so we
		//can use it places where said calls aren't appropriate.
		call_user_func_array('print_stop_message', $e->getParams());
	}


	/*
		Figure out what we want to do in the end.
		What we'd like to do is
			1. If don't need a merge, print the stop message which redirects to either the defined redirect
				for the product or the default redirect (aka the products admin page)
			2. If we do, then redirect to the merge page which will redirect to the proper redirect page
				when finished.

		As always users complicate things.  Some products want to display errors which get unreadable when
		the page automatically redirects.  We have a DISABLE_PRODUCT_REDIRECT flag which is supposed to
		simply display the stop message and not redirect.
	*/

	$default_redirect = 'index.php?loc=' . urlencode('apm_product.php?do=product');
	if (!defined('DISABLE_PRODUCT_REDIRECT'))
	{
		define('CP_REDIRECT', $default_redirect);
	}

	if ($info['need_merge'])
	{
		$merge_url = 'template.php?do=massmerge&product=' . urlencode($info['productid']) .
			'&hash=' . CP_SESSIONHASH . '&redirect=' . urlencode(defined('CP_REDIRECT') ? CP_REDIRECT : $default_redirect);

		if (!defined('DISABLE_PRODUCT_REDIRECT'))
		{
			print_cp_redirect($merge_url);
		}
		else
		{
			//if we just don't define the back url we'll get a javascript "back" as default.
			//an empty string (instead of null) triggers no back button, which is what we want.
			//ugly, but it avoids rewriting a lot of the logic in print_stop_message here.
			define('CP_BACKURL', '');

			//handle the merge redirect as a continue url instead of immediately redirecting.
			define('CP_CONTINUE', $merge_url);

			print_stop_message('product_x_imported_need_merge', $info['productid'], htmlspecialchars($merge_url));
		}
	}
	else
	{
		print_stop_message('product_x_imported', $info['productid']);
	}

}

// #############################################################################

if ($_REQUEST['do'] == 'productexport')
{
	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_XML_Builder($vbulletin);

	$vbulletin->input->clean_array_gpc('r', array(
		'productid'	=> TYPE_STR
	));

	//	Set up the parent tag
	$apm_product_details = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
	");

	if (!$apm_product_details)
	{
		print_stop_message('invalid_product_specified');
	}

	$export_styleid = -1;
	$export_languageids = array(-1, 0);

	// ############## main product info
	$xml->add_group('product', array(
		'productid' => strtolower($apm_product_details['productid']),
		'active' => $apm_product_details['active']
	)); // Parent for product
	
	$xml->add_tag('title', $apm_product_details['title']);
	$xml->add_tag('description', $apm_product_details['description']);
	$xml->add_tag('version', $apm_product_details['version']);
	$xml->add_tag('url', $apm_product_details['url']);
	$xml->add_tag('versioncheckurl', $apm_product_details['versioncheckurl']);
	$xml->add_tag('apm_releasedate', $apm_product_details['apm_releasedate']);
	$xml->add_tag('apm_author', $apm_product_details['apm_author']);
	$xml->add_tag('apm_relatedurl', $apm_product_details['apm_relatedurl']);
	$xml->add_tag('apm_extrainfo', $apm_product_details['apm_extrainfo']);
	$xml->add_tag('apm_extraedit', $apm_product_details['apm_extraedit']);
	($hook = vBulletinHook::fetch_hook('admin_product_export')) ? eval($hook) : false;
	// ############## dependencies
	$product_dependencies = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "productdependency
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
		ORDER BY dependencytype, parentproductid, minversion
	");

	$xml->add_group('dependencies');

	while ($product_dependency = $db->fetch_array($product_dependencies))
	{
		$deps = array('dependencytype' => $product_dependency['dependencytype']);
		if ($product_dependency['dependencytype'] == 'product')
		{
			$deps['parentproductid'] = $product_dependency['parentproductid'];
		}
		$deps['minversion'] = $product_dependency['minversion'];
		$deps['maxversion'] = $product_dependency['maxversion'];

		$xml->add_tag('dependency', '', $deps);
	}

	$xml->close_group();

	// ############## install / uninstall codes
	$productcodes = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "productcode
		WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
	");

	$xml->add_group('codes');

	$productcodes_grouped = array();
	$productcodes_versions = array();

	while ($productcode = $db->fetch_array($productcodes))
	{
		// have to be careful here, as version numbers are not necessarily unique
		$productcodes_versions["$productcode[version]"] = 1;
		$productcodes_grouped["$productcode[version]"][] = $productcode;
	}

	$productcodes_versions = array_keys($productcodes_versions);
	usort($productcodes_versions, 'version_sort');

	foreach ($productcodes_versions AS $version)
	{
		foreach ($productcodes_grouped["$version"] AS $productcode)
		{
			$xml->add_group('code', array('version' => $productcode['version']));
				$xml->add_tag('installcode', $productcode['installcode']);
				$xml->add_tag('uninstallcode', $productcode['uninstallcode']);
			$xml->close_group();
		}
	}

	$xml->close_group();

	//hack in the ability to handle styles other than the master in a sane fashion.
	//We can set it via a hook for the moment, it should be a fairly temporary need.
	//There was some logic that look like you might be able to export more than one
	//style, but it didn't make much sense -- if you selected multiple styles then
	//you'd end up with templates from multiple styles with no attempt to handle duplicates
	//and no requirement that the styles in question were parents/children of each other.
	if ($export_styleid == -1)
	{
		$sqlcondition = "styleid = -1";
		$parentlist = "-1";
	}
	else
	{
		// query everything from the specified style
		$style = $db->query_first($q = "SELECT * FROM " . TABLE_PREFIX . "style WHERE styleid = " . $export_styleid);
		$sqlcondition = "templateid IN(" . implode(',', unserialize($style['templatelist'])) . ")";
		$parentlist = $style['parentlist'];
	}

	// ############## templates
	$gettemplates = $db->query_read("
		SELECT title, templatetype, username, dateline, version, product,
			IF(templatetype = 'template', template_un, template) AS template
		FROM " . TABLE_PREFIX . "template
		WHERE product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			AND $sqlcondition
		ORDER BY title
	");

	$xml->add_group('templates');

	while ($template = $db->fetch_array($gettemplates))
	{
		if (is_newer_version($template['version'], $apm_product_details['version']))
		{
			// version in the template is newer than the version of the product,
			// which probably means it's using the vB version
			$template['version'] = $apm_product_details['version'];
		}
		$xml->add_tag('template', $template['template'], array(
			'name' => htmlspecialchars($template['title']),
			'templatetype' => $template['templatetype'],
			'date' => $template['dateline'],
			'username' => $template['username'],
			'version' => htmlspecialchars_uni($template['version'])
		), true);
	}

	$xml->close_group();

	// ############## Stylevars
	$stylevarinfo = get_stylevars_for_export($vbulletin->GPC['productid'], $parentlist, true);
	$stylevar_cache = $stylevarinfo['stylevars'];
	$stylevar_dfn_cache = $stylevarinfo['stylevardfns'];


	$xml->add_group('stylevardfns');
	foreach ($stylevar_dfn_cache AS $stylevargroupname => $stylevargroup)
	{
		$xml->add_group('stylevargroup', array('name' => $stylevargroupname));
		foreach($stylevargroup AS $stylevar)
		{
			$xml->add_tag('stylevar', '', array('name' => htmlspecialchars($stylevar['stylevarid']), 'datatype' => $stylevar['datatype'], 'validation' => base64_encode($stylevar['validation']), 'failsafe' => base64_encode($stylevar['failsafe'])));
		}
		$xml->close_group();
	}
	$xml->close_group();
	unset($stylevar_dfn_cache);


	$xml->add_group('stylevars');
	foreach ($stylevar_cache AS $stylevarid => $stylevar)
	{
		$xml->add_tag('stylevar', '', array('name' => htmlspecialchars($stylevar['stylevarid']), 'value' => base64_encode($stylevar['value'])));
	}
	$xml->close_group();
	unset($stylevar_dfn_cache);

	// ############## plugins

	$xml->add_group('plugins');

	$plugins = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "plugin
		WHERE product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
		ORDER BY hookname
	");
	while ($plugin = $db->fetch_array($plugins))
	{
		$params = array('active' => $plugin['active'], 'executionorder' => $plugin['executionorder']);

		$xml->add_group('plugin', $params);
			$xml->add_tag('title', $plugin['title']);
			$xml->add_tag('hookname', $plugin['hookname']);
			$xml->add_tag('phpcode', $plugin['phpcode']);
		$xml->close_group();
	}

	unset($plugin);
	$db->free_result($plugins);
	$xml->close_group();

	// ############## phrases
	require_once(DIR . '/includes/adminfunctions_language.php');

	$phrasetypes = fetch_phrasetypes_array(false);

	$phrases = array();
	$getphrases = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "phrase
		WHERE languageid IN (" . implode(',', $export_languageids) . ")
			AND product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
		ORDER BY languageid, fieldname, varname
	");
	while ($getphrase = $db->fetch_array($getphrases))
	{
		$phrases["$getphrase[fieldname]"]["$getphrase[varname]"] = $getphrase;
	}
	unset($getphrase);
	$db->free_result($getphrases);

	$xml->add_group('phrases');

	// make sure the phrasegroups are in a reliable order
	ksort($phrases);

	foreach ($phrases AS $_fieldname => $typephrases)
	{
		// create a group for each phrase type that we have phrases for
		// then insert the phrases

		$xml->add_group('phrasetype', array('name' => $phrasetypes["$_fieldname"]['title'], 'fieldname' => $_fieldname));

		// make sure the phrases are in a reliable order
		ksort($typephrases);

		foreach ($typephrases AS $phrase)
		{
			$xml->add_tag('phrase', $phrase['text'], array(
				'name' => $phrase['varname'],
				'date' => $phrase['dateline'],
				'username' => $phrase['username'],
				'version' => htmlspecialchars_uni($phrase['version'])
			), true);
		}

		$xml->close_group();
	}

	$xml->close_group();

	// ############## options
	$setting = array();
	$settinggroup = array();

	$groups = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "settinggroup
		WHERE volatile = 1
		ORDER BY displayorder, grouptitle
	");
	while ($group = $db->fetch_array($groups))
	{
		$settinggroup["$group[grouptitle]"] = $group;
	}

	ksort($settinggroup);

	$options = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "setting
		WHERE product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			AND volatile = 1
		ORDER BY displayorder, varname
	");
	while ($row = $db->fetch_array($options))
	{
		$setting["$row[grouptitle]"][] = $row;
	}
	unset($row);

	$db->free_result($options);

	$xml->add_group('options');

	foreach ($settinggroup AS $grouptitle => $group)
	{
		if (empty($setting["$grouptitle"]))
		{
			continue;
		}

		// add a group for each setting group we have settings for

		$xml->add_group('settinggroup', array('name' => htmlspecialchars($group['grouptitle']), 'displayorder' => $group['displayorder']));

		ksort($setting["$grouptitle"]);

		foreach($setting["$grouptitle"] AS $set)
		{
			$arr = array('varname' => $set['varname'], 'displayorder' => $set['displayorder']);
			if ($set['advanced'])
			{
				$arr['advanced'] = 1;
			}
			$xml->add_group('setting', $arr);

			if ($set['datatype'])
			{
				$xml->add_tag('datatype', $set['datatype']);
			}
			if ($set['optioncode'] != '')
			{
				$xml->add_tag('optioncode', $set['optioncode']);
			}
			if ($set['validationcode'])
			{
				$xml->add_tag('validationcode', $set['validationcode']);
			}
			if ($set['defaultvalue'] !== '')
			{
				$xml->add_tag('defaultvalue', $set['defaultvalue']);
			}
			if ($set['blacklist'])
			{
				$xml->add_tag('blacklist', 1);
			}

			$xml->close_group();
		}

		$xml->close_group();
	}

	$xml->close_group();

	// ############## admin help
	$help_topics_results = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "adminhelp
		WHERE product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			AND volatile = 1
		ORDER BY script, action, displayorder, optionname
	");
	$help_topics = array();
	while ($help_topic = $db->fetch_array($help_topics_results))
	{
		$help_topics["$help_topic[script]"][] = $help_topic;
	}
	$db->free_result($help_topics_results);
	ksort($help_topics);

	$xml->add_group('helptopics');

	foreach ($help_topics AS $script => $script_topics)
	{
		$xml->add_group('helpscript', array('name' => $script));
		foreach ($script_topics AS $topic)
		{
			$attr = array('disp' => $topic['displayorder']);
			if ($topic['action'])
			{
				$attr['act'] = $topic['action'];
			}
			if ($topic['optionname'])
			{
				$attr['opt'] = $topic['optionname'];
			}
			$xml->add_tag('helptopic', '', $attr);
		}
		$xml->close_group();
	}

	$xml->close_group();

	// ############## Cron entries
	$cron_results = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "cron
		WHERE product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			AND volatile = 1
			AND varname <> ''
		ORDER BY varname
	");

	$xml->add_group('cronentries');

	while ($cron = $db->fetch_array($cron_results))
	{
		$minutes = unserialize($cron['minute']);
		if (!is_array($minutes))
		{
			$minutes = array();
		}

		$xml->add_group('cron', array(
			'varname' => $cron['varname'],
			'active' => $cron['active'],
			'loglevel' => $cron['loglevel']
		));
		$xml->add_tag('filename', $cron['filename']);
		$xml->add_tag('scheduling', '', array(
			'weekday' => $cron['weekday'],
			'day' => $cron['day'],
			'hour' => $cron['hour'],
			'minute' => implode(',', $minutes)
		));
		$xml->close_group();
	}

	$xml->close_group();

	$db->free_result($cron_results);

	// ############## FAQ entries

	$faq_results = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "faq
		WHERE product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			AND volatile = 1
		ORDER BY faqname
	");

	$xml->add_group('faqentries');

	while ($faq = $db->fetch_array($faq_results))
	{
		$xml->add_tag('faq', '', array(
			'faqname' => $faq['faqname'],
			'faqparent' => $faq['faqparent'],
			'displayorder' => $faq['displayorder'],
		));
	}

	$xml->close_group();

	$db->free_result($faq_results);

	// ############## Finish up
	$xml->close_group();
	$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n" . $xml->output();

	unset($xml);

	require_once(DIR . '/includes/functions_file.php');
	file_download($doc, "product-" . $vbulletin->GPC['productid'] . '.xml', 'text/xml');
}
// ####################################

// #############################################################################

/* OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA */
/* reference from phrase.php */
if ($_POST['do'] == 'killphrase')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'productid'		=> TYPE_STR,
		'phraseid' => TYPE_INT,
		'fieldname'       => TYPE_NOHTML,
		'pagenumber'      => TYPE_UINT,
		'perpage'         => TYPE_UINT,
		'sourcefieldname' => TYPE_NOHTML,
		'showphrases'			=> TYPE_UINT,
	));

	if ($getvarname = $db->query_first("SELECT varname, fieldname FROM " . TABLE_PREFIX . "phrase WHERE phraseid = " . $vbulletin->GPC['phraseid']))
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase
			WHERE varname = '" . $db->escape_string($getvarname['varname']) . "'
				AND fieldname = '" . $db->escape_string($getvarname['fieldname']) . "'
		");

		build_language(-1);

		define('CP_REDIRECT', "apm_product.php?do=managedetails&amp;productid=" . $vbulletin->GPC['productid'] ."&amp;showphrases=".$vbulletin->GPC['showphrases']);
		print_stop_message('deleted_phrase_successfully');
	}
	else
	{
		print_stop_message('invalid_phrase_specified');
	}
}

// #############################################################################

if ($_POST['do'] == 'updatephrase')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'fieldname'       => TYPE_NOHTML,
		'oldfieldname'    => TYPE_NOHTML,
		'languageid'      => TYPE_INT,
		'oldvarname'      => TYPE_STR,
		'varname'         => TYPE_STR,
		'text'            => TYPE_ARRAY_NOTRIM,
		'ismaster'        => TYPE_INT,
		'sourcefieldname' => TYPE_NOHTML,
		't'               => TYPE_BOOL,
		'showphrases'			=> TYPE_UINT,
	));

	if (empty($vbulletin->GPC['varname']))
	{
		print_stop_message('please_complete_required_fields');
	}

	if (!preg_match('#^[a-z0-9_\[\]]+$#i', $vbulletin->GPC['varname'])) // match a-z, A-Z, 0-9, ',', _ only .. allow [] for help items
	{
		print_stop_message('invalid_phrase_varname');
	}

	if ($vbulletin->GPC['varname'] != $vbulletin->GPC['oldvarname'] AND $test = $db->query_first("SELECT phraseid FROM " . TABLE_PREFIX . "phrase WHERE varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "' AND languageid IN(0,-1) AND fieldname = '" . $db->escape_string($vbulletin->GPC['fieldname']) . "'"))
	{
		print_stop_message('variable_name_exists', $vbulletin->GPC['oldvarname'], $vbulletin->GPC['varname']);
	}

	// delete old phrases
	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "phrase
		WHERE varname = '" . $db->escape_string($vbulletin->GPC['oldvarname']) . "' AND
				fieldname = '" . $db->escape_string($vbulletin->GPC['oldfieldname']) . "'
		" . ($vbulletin->GPC['t'] ? " AND languageid NOT IN(-1,0)" : "") . "
		" . (!$vbulletin->debug ? ' AND languageid <> -1' : '') . "
	");

	// now set some variables and go ahead to the insert action
	$update = 1;
	$vbulletin->GPC['ismaster'] = ($vbulletin->GPC['languageid'] == -1) ? true : false;
	$_POST['do'] = 'insertphrase';
}

// #############################################################################

if ($_POST['do'] == 'insertphrase')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'sourcefieldname' => TYPE_NOHTML,
		'fieldname'       => TYPE_NOHTML,
		'varname'         => TYPE_STR,
		'text'            => TYPE_ARRAY_NOTRIM,
		'ismaster'        => TYPE_INT,
		'pagenumber'      => TYPE_UINT,
		'perpage'         => TYPE_UINT,
		'product'         => TYPE_STR,
		'showphrases'     => TYPE_UINT,
	));

	if (empty($update))
	{
		if ((empty($vbulletin->GPC['text'][0]) AND $vbulletin->GPC['text'][0] != '0' AND !$vbulletin->GPC['t']) OR empty($vbulletin->GPC['varname']))
		{
			print_stop_message('please_complete_required_fields');
		}

		if (!preg_match('#^[a-z0-9_\[\]]+$#i', $vbulletin->GPC['varname'])) // match a-z, A-Z, 0-9, ',', _ only .. allow [] for help items
		{
			print_stop_message('invalid_phrase_varname');
		}

		if ($db->query_first("SELECT phraseid FROM " . TABLE_PREFIX . "phrase WHERE varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "' AND languageid IN(0,-1) AND fieldname = '" . $db->escape_string($vbulletin->GPC['fieldname']) . "'"))
		{
			print_stop_message('there_is_already_phrase_named_x', $vbulletin->GPC['varname']);
		}
	}

	if ($vbulletin->GPC['ismaster'])
	{
		if ($vbulletin->debug AND !$vbulletin->GPC['t'])
		{
			/*insert query*/
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrase
					(languageid, varname, text, fieldname, product, username, dateline, version)
				VALUES
					(-1,
					'" . $db->escape_string($vbulletin->GPC['varname']) . "',
					'" . $db->escape_string($vbulletin->GPC['text'][0]) . "',
					'" . $db->escape_string($vbulletin->GPC['fieldname']) . "',
					'" . $db->escape_string($vbulletin->GPC['product']) . "',
					'" . $db->escape_string($vbulletin->userinfo['username']) . "',
					" . TIMENOW . ",
					'" . $db->escape_string($full_product_info[$vbulletin->GPC['product']]['version']) . "')
			");
		}

		unset($vbulletin->GPC['text'][0]);
	}

	foreach($vbulletin->GPC['text'] AS $_languageid => $txt)
	{
		$_languageid = intval($_languageid);
		if (!empty($txt) OR $txt == '0')
		{
			/*insert query*/
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrase
					(languageid, varname, text, fieldname, product, username, dateline, version)
				VALUES
					($_languageid,
					'" . $db->escape_string($vbulletin->GPC['varname']) . "',
					'" . $db->escape_string($txt) . "',
					'" . $db->escape_string($vbulletin->GPC['fieldname']) . "',
					'" . $db->escape_string($vbulletin->GPC['product']) . "',
					'" . $db->escape_string($vbulletin->userinfo['username']) . "',
					" . TIMENOW . ",
					'" . $db->escape_string($full_product_info[$vbulletin->GPC['product']]['version']) . "')
			");
		}
	}

	build_language(-1);

	define('CP_REDIRECT', "apm_product.php?do=managedetails&amp;productid=" . $vbulletin->GPC['product'] . "&amp;showphrases=".$vbulletin->GPC['showphrases']);
	print_stop_message('saved_phrase_x_successfully', $vbulletin->GPC['varname']);
}


// #############################################################################


if ($_REQUEST['do'] == 'addphrase' OR $_REQUEST['do'] == 'editphrase')
{
?>
<script type="text/javascript">
function copy_default_text(targetlanguage)
{
	var deftext = fetch_object("default_phrase").value
	if (deftext == "")
	{
		alert("<?php echo $vbphrase['default_text_is_empty']; ?>");
	}
	else
	{
		fetch_object("text_" + targetlanguage).value = deftext;
	}
}
</script>
<?php
}

// #############################################################################

if ($_REQUEST['do'] == 'addphrase')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid'       => TYPE_STR,
		'fieldname'       => TYPE_NOHTML,
		'pagenumber'      => TYPE_UINT,
		'perpage'         => TYPE_UINT,
		'showphrases'     => TYPE_UINT,
	));

	// make phrasetype options
	$phrasetypes = fetch_phrasetypes_array();
	$typeoptions = array();
	$type_product_options = array();
	foreach($phrasetypes AS $fieldname => $phrasetype)
	{
		$typeoptions["$fieldname"] = $phrasetype['title'];
		$type_product_options["$fieldname"] = $phrasetype['product'];
	}

	print_form_header('apm_product', 'insertphrase');
	print_table_header($vbphrase['add_new_phrase']);

	if ($vbulletin->debug)
	{
		print_yes_no_row(construct_phrase($vbphrase['insert_into_master_language_developer_option'], "<b></b>"), 'ismaster', iif($vbulletin->debug, 1, 0));
	}

	print_select_row($vbphrase['phrase_type'], 'fieldname', $typeoptions, $vbulletin->GPC['fieldname']);

	print_select_row($vbphrase['product'], 'product', fetch_product_list(), $vbulletin->GPC['productid']);

	// main input fields
	$resizer = "<div class=\"smallfont\"><a href=\"#\" onclick=\"return resize_textarea(1, 'default_phrase')\">$vbphrase[increase_size]</a> <a href=\"#\" onclick=\"return resize_textarea(-1, 'default_phrase')\">$vbphrase[decrease_size]</a></div>";
	print_input_row($vbphrase['varname'], 'varname', '', 1, 60);
	print_label_row(
		$vbphrase['text']  . $resizer,
		"<textarea name=\"text[0]\" id=\"default_phrase\" rows=\"5\" cols=\"60\" wrap=\"virtual\" tabindex=\"1\" dir=\"ltr\"" . iif($vbulletin->debug, ' title="name=&quot;text[0]&quot;"') . "></textarea>",
		'', 'top', 'text[0]'
	);

	// do translation boxes
	print_table_header($vbphrase['translations']);
	print_description_row("
			<ul><li>$vbphrase[phrase_translation_desc_1]</li>
			<li>$vbphrase[phrase_translation_desc_2]</li>
			<li>$vbphrase[phrase_translation_desc_3]</li></ul>
		",
		0, 2, 'tfoot'
	);
	$languages = fetch_languages_array();
	foreach($languages AS $_languageid => $lang)
	{
		$resizer = "<div class=\"smallfont\"><a href=\"#\" onclick=\"return resize_textarea(1, 'text_$_languageid')\">$vbphrase[increase_size]</a> <a href=\"#\" onclick=\"return resize_textarea(-1, 'text_$_languageid')\">$vbphrase[decrease_size]</a></div>";

		print_label_row(
			construct_phrase($vbphrase['x_translation'], "<b>$lang[title]</b>") . " <dfn>($vbphrase[optional])</dfn><br /><input type=\"button\" class=\"button\" value=\"$vbphrase[copy_default_text]\" tabindex=\"1\" onclick=\"copy_default_text($_languageid);\" />" . $resizer,
			"<textarea name=\"text[$_languageid]\" id=\"text_$_languageid\" rows=\"5\" cols=\"60\" tabindex=\"1\" wrap=\"virtual\" dir=\"$lang[direction]\"></textarea>"
		);
		print_description_row('<img src="../' . $vbulletin->options['cleargifurl'] . '" width="1" height="1" alt="" />', 0, 2, 'thead');
	}

	construct_hidden_code('page', $vbulletin->GPC['pagenumber']);
	construct_hidden_code('perpage', $vbulletin->GPC['perpage']);
	construct_hidden_code('sourcefieldname', $vbulletin->GPC['fieldname']);
	construct_hidden_code('showphrases', $vbulletin->GPC['showphrases']);
	print_submit_row($vbphrase['save']);
}

// #############################################################################

if ($_REQUEST['do'] == 'editphrase')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'phraseid' => TYPE_INT,
		'e'          => TYPE_ARRAY_ARRAY,
		'delete'     => TYPE_ARRAY_ARRAY,
		'pagenumber' => TYPE_UINT,
		'perpage'    => TYPE_UINT,
		'fieldname'  => TYPE_NOHTML,
		'varname'    => TYPE_STR,
		't'          => TYPE_BOOL,		// Display only the translations and no delete button
		'showphrases'=> TYPE_UINT,
	));
	if (!empty($vbulletin->GPC['delete']))
	{
		$editvarname =& $vbulletin->GPC['delete'];
		$_REQUEST['do'] = 'delete';
	}
	else
	{
		$editvarname =& $vbulletin->GPC['e'];
	}

	// make phrasetype options
	$phrasetypes = fetch_phrasetypes_array();
	$typeoptions = array();
	foreach($phrasetypes AS $fieldname => $phrasetype)
	{
		$typeoptions["$fieldname"] = $phrasetype['title'];
	}

	if (!empty($editvarname))
	{
		foreach($editvarname AS $fieldname => $varnames)
		{
			foreach($varnames AS $varname => $type)
			{
				$varname = urldecode($varname);
				$phrase['fieldname'] = $fieldname;
				$phrase = $db->query_first("
					SELECT * FROM " . TABLE_PREFIX . "phrase
					WHERE varname = '" . $db->escape_string($varname) . "' AND
							fieldname = '" . $db->escape_string($phrase['fieldname']) . "'
					ORDER BY languageid
					LIMIT 1
				");
				break;
			}
		}
	}
	else if ($vbulletin->GPC['phraseid'])
	{
		$phrase = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "phrase WHERE phraseid = " . $vbulletin->GPC['phraseid']);
	}
	else if ($vbulletin->GPC['fieldname'] AND $vbulletin->GPC['varname'])
	{
		$varname = urldecode($vbulletin->GPC['varname']);
		$phrase = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "phrase
			WHERE varname = '" . $db->escape_string($varname) . "' AND
					fieldname = '" . $db->escape_string($vbulletin->GPC['fieldname']) . "'
			ORDER BY languageid
			LIMIT 1
		");
	}

	if (!$phrase['phraseid'] OR !$phrase['varname'])
	{
		print_stop_message('no_phrases_matched_your_query');
	}

	if ($_REQUEST['do'] == 'deletephrase')
	{
		$vbulletin->GPC['phraseid'] = $phrase['phraseid'];
	}
	else
	{
		// delete link
		if (($vbulletin->debug OR $phrase['languageid'] != '-1') AND !$vbulletin->GPC['t'])
		{
			print_form_header('apm_product', 'deletephrase');
			construct_hidden_code('phraseid', $phrase['phraseid']);
			construct_hidden_code('productid', $phrase['product']);
			construct_hidden_code('showphrases', $vbulletin->GPC['showphrases']);
			print_table_header($vbphrase['if_you_would_like_to_remove_this_phrase'] . ' &nbsp; &nbsp; <input type="submit" class="button" tabindex="1" value="' . $vbphrase['delete'] . '" />');
			print_table_footer();
		}

		//. '<input type="hidden" id="default_phrase" value="' . htmlspecialchars_uni($phrase['text']) . '" />'

		print_form_header('apm_product', 'updatephrase', false, true, 'phraseform');

		print_table_header(construct_phrase($vbphrase['x_y_id_z'], iif(
			$phrase['languageid'] == 0,
			$vbphrase['custom_phrase'],
			$vbphrase['standard_phrase']
		), $phrase['varname'], $phrase['phraseid']));
		construct_hidden_code('mode', $mode);
		construct_hidden_code('oldvarname', $phrase['varname']);
		construct_hidden_code('t', $vbulletin->GPC['t']);

		if ($vbulletin->debug)
		{
			print_select_row($vbphrase['language'], 'languageid', array('-1' => $vbphrase['master_language'], '0' => $vbphrase['custom_language']), $phrase['languageid']);
			construct_hidden_code('oldfieldname', $phrase['fieldname']);
			print_select_row($vbphrase['phrase_type'], 'fieldname', $typeoptions, $phrase['fieldname']);
		}
		else
		{
			construct_hidden_code('languageid', $phrase['languageid']);
			construct_hidden_code('oldfieldname', $phrase['fieldname']);
			construct_hidden_code('fieldname', $phrase['fieldname']);
		}

		print_select_row($vbphrase['product'], 'product', fetch_product_list(), $phrase['product']);

		if (($phrase['languageid'] == 0 OR $vbulletin->debug) AND !$vbulletin->GPC['t'])
		{
			$resizer = "<div class=\"smallfont\"><a href=\"#\" onclick=\"return resize_textarea(1, 'default_phrase')\">$vbphrase[increase_size]</a> <a href=\"#\" onclick=\"return resize_textarea(-1, 'default_phrase')\">$vbphrase[decrease_size]</a></div>";

			print_input_row($vbphrase['varname'], 'varname', $phrase['varname'], 1, 50);
			print_label_row(
				$vbphrase['text'] . $resizer,
				"<textarea name=\"text[0]\" id=\"default_phrase\" rows=\"4\" cols=\"50\" wrap=\"virtual\" tabindex=\"1\" dir=\"ltr\"" . iif($vbulletin->debug, ' title="name=&quot;text[0]&quot;"') . ">" . htmlspecialchars_uni($phrase['text']) . "</textarea>",
				'', 'top', 'text[0]'
			);
		}
		else
		{
			print_label_row($vbphrase['varname'], '$vbphrase[<b>' . $phrase['varname'] . '</b>]');
			construct_hidden_code('varname', $phrase['varname']);

			print_label_row($vbphrase['text'], nl2br(htmlspecialchars_uni($phrase['text'])) . '<input type="hidden" id="default_phrase" value="' . htmlspecialchars_uni($phrase['text']) . '" />');
			if (!$vbulletin->GPC['t'])
			{
				construct_hidden_code('text[0]', $phrase['text']);
			}
		}

		// do translation boxes
		print_table_header($vbphrase['translations']);
		print_description_row("
				<ul><li>$vbphrase[phrase_translation_desc_1]</li>
				<li>$vbphrase[phrase_translation_desc_2]</li>
				<li>$vbphrase[phrase_translation_desc_3]</li></ul>
			",
			0, 2, 'tfoot'
		);

		$translations = $db->query_read("
			SELECT languageid, text
			FROM " . TABLE_PREFIX . "phrase
			WHERE varname = '" . $db->escape_string($phrase['varname']) . "' AND
				languageid <> $phrase[languageid] AND
				fieldname = '" . $db->escape_string($phrase[fieldname]) . "'
		");
		while ($translation = $db->fetch_array($translations))
		{
			$text["{$translation['languageid']}"] = $translation['text'];
		}

		// remove escape junk from javascript phrases for nice editable look
		fetch_js_unsafe_string($text);

		$languages = fetch_languages_array();
		foreach($languages AS $_languageid => $lang)
		{
			$resizer = "<div class=\"smallfont\"><a href=\"#\" onclick=\"return resize_textarea(1, 'text_$_languageid')\">$vbphrase[increase_size]</a> <a href=\"#\" onclick=\"return resize_textarea(-1, 'text_$_languageid')\">$vbphrase[decrease_size]</a></div>";

			print_label_row(
				construct_phrase($vbphrase['x_translation'], "<b>$lang[title]</b>") . " <dfn>($vbphrase[optional])</dfn><br /><input type=\"button\" class=\"button\" value=\"$vbphrase[copy_default_text]\" tabindex=\"1\" onclick=\"copy_default_text($_languageid);\" />" . $resizer,
				"<textarea name=\"text[$_languageid]\" id=\"text_$_languageid\" rows=\"5\" cols=\"60\" tabindex=\"1\" wrap=\"virtual\" dir=\"$lang[direction]\">" . htmlspecialchars_uni($text["$_languageid"]) . "</textarea>"
			);
			print_description_row('<img src="../' . $vbulletin->options['cleargifurl'] . '" width="1" height="1" alt="" />', 0, 2, 'thead');
		}

		construct_hidden_code('page', $vbulletin->GPC['pagenumber']);
		construct_hidden_code('perpage', $vbulletin->GPC['perpage']);
		construct_hidden_code('sourcefieldname', $vbulletin->GPC['fieldname']);
		construct_hidden_code('showphrases', $vbulletin->GPC['showphrases']);
		print_submit_row($vbphrase['save']);
	}
}

// #############################################################################

if ($_REQUEST['do'] == 'deletephrase')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid'		=> TYPE_STR,
		'phraseid'		=> TYPE_INT,
		'pagenumber'	=> TYPE_UINT,
		'perpage'			=> TYPE_UINT,
		'fieldname'		=> TYPE_NOHTML,
		'showphrases'	=> TYPE_UINT,
	));

	//Check if Phrase belongs to Master Language -> only able to delete if $vbulletin->debug=1
	$getvarname = $db->query_first("SELECT varname, fieldname FROM " . TABLE_PREFIX . "phrase WHERE phraseid=" . $vbulletin->GPC['phraseid']);
	$ismasterphrase = $db->query_first("
		SELECT languageid FROM " . TABLE_PREFIX . "phrase
		WHERE varname = '" . $getvarname['varname'] . "' AND
			languageid = '-1'" . iif($getvarname['fieldname'], " AND
			fieldname = '" . $db->escape_string($getvarname['fieldname']) . "'")
	);
	if (!$vbulletin->debug AND $ismasterphrase)
	{
		print_stop_message('cant_delete_master_phrase');
	}

	print_delete_confirmation('phrase', $vbulletin->GPC['phraseid'], 'apm_product', 'killphrase', 'phrase', array(
		'sourcefieldname' => $vbulletin->GPC['fieldname'],
		'fieldname' => $getvarname['fieldname'], 
		'pagenumber' => $vbulletin->GPC['pagenumber'], 
		'perpage' => $vbulletin->GPC['perpage'],
		'productid' => $vbulletin->GPC['productid'],
		'showphrases' => $vbulletin->GPC['showphrases']
	), $vbphrase['if_you_delete_this_phrase_translations_will_be_deleted']);
}

// #############################################################################



/* OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA * * OFF MTHA */

// ######################### MANAGE DETAIL #########################################3
if ($_REQUEST['do'] == 'managedetails')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid' => TYPE_STR,
		'showall' => TYPE_STR,
		'showplugins' =>TYPE_STR,
		'showphrases' => TYPE_STR,
		'showtemplates' => TYPE_STR,
		'showsettings' => TYPE_STR,
	));

		$products = fetch_product_list(true);
		
		if ($vbulletin->GPC['productid'])
		{
			$product = $db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "product
				WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			");
		}
		
		if ($product)
		{
			print_table_start(0);
			print_table_header("$vbphrase[product]: $product[title] <span class=\"smallfont\">($product[productid])</span><br>" 
			.  construct_link_code($vbphrase['apm_showall'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=managedetails&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showall=1",0,'',1)
			.  construct_link_code($vbphrase['apm_plugins'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=managedetails&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showplugins=1",0,'',1)
			.  construct_link_code($vbphrase['apm_phrases'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=managedetails&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showphrases=1",0,'',1)
			.  construct_link_code($vbphrase['apm_templates'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=managedetails&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showtemplates=1",0,'',1)
			.  construct_link_code($vbphrase['apm_settings'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=managedetails&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showsettings=1",0,'',1)

			);
			print_description_row($product['description']);
			print_table_footer(1, '', '', false);
		}
		else
		{
			define('CP_REDIRECT', 'apm_product.php?do=product');
			print_stop_message('invalid_product_specified');
		}

		$showproductinfo = '1';

	if (!$vbulletin->GPC['showall'] && !$vbulletin->GPC['showplugins'] && !$vbulletin->GPC['showphrases'] && !$vbulletin->GPC['showtemplates'] && !$vbulletin->GPC['showsettings'] && !$vbulletin->GPC['showadminhelp'] && !$vbulletin->GPC['showfaq'] && !$vbulletin->GPC['showTMS'])
	{
		$vbulletin->GPC['showall'] = '1';
	}

	if ($product && $vbulletin->GPC['showall'])
	{
//		$vbulletin->GPC['showdependancies'] = '1';
//		$vbulletin->GPC['showinstallcode'] = '1';
//		$vbulletin->GPC['showplugins'] = '1';
//		$vbulletin->GPC['showphrases'] = '1';
//		$vbulletin->GPC['showtemplates'] = '1';
//		$vbulletin->GPC['showsettings'] = '1';
//		$vbulletin->GPC['showcrons']	= '1';
//		$vbulletin->GPC['showadminhelp']	= '1';		
//		$vbulletin->GPC['showfaq']	= '1';		
//		$vbulletin->GPC['showTMS']	= '1';
	}

	// ###################### Start product display ######################
	if ($showproductinfo)
	{
		if (!$product)
		{
			print_form_header('apm_product', 'productimport', 1, 1, 'uploadform" onsubmit="return js_confirm_upload(this, this.pluginfile);');
			print_table_header($vbphrase['import_product']);
			print_upload_row($vbphrase['upload_xml_file'], 'productfile', 999999999);
			print_input_row($vbphrase['import_xml_file'], 'serverfile', './includes/xml/product.xml');
			print_yes_no_row($vbphrase['allow_overwrite_upgrade_product'], 'allowoverwrite', 0);
			print_submit_row($vbphrase['import']);
		}
	
		print_form_header('apm_product', 'productsave', false, true, 'productsave');
		if ($product['active'])
		{
			$productstatuslink = construct_link_code($vbphrase['disable'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=productdisable&amp;productid=" . $vbulletin->GPC['productid']);
		}
		else
		{
			$productstatuslink = construct_link_code($vbphrase['enable'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=productenable&amp;productid=" . $vbulletin->GPC['productid']);
		}
			
		$editproductoptions = '<span class="smallfont">' . $productstatuslink  . ' 
		' . construct_link_code($vbphrase['export'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=productexport&amp;productid=" . $vbulletin->GPC['productid']) . '  
		' . construct_link_code($vbphrase['uninstall'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=productdelete&amp;productid=" . $vbulletin->GPC['productid']) . '
		</span>';
	
		if ($product)
		{
			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('edit_product')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_edit_product\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_edit_product"]}.gif\" /></a></span> $vbphrase[edit] $vbphrase[product] $editproductoptions");
			echo("<tbody id=\"collapseobj_edit_product\" style=\"" . $vbcollapse["collapseobj_edit_product"] . "\">");
	
			if (!$product['active'])
			{
				//$product['productid'] = "<strike style=\"color:red\"> " . $product['productid'] . "</strike>";
				print_label_row($vbphrase['product_id'], "<strike style=\"color:red\"> " . $product['productid'] . "</strike>");
				$product['status'] = $vbphrase['disable'];
			}
			else
			{
				print_label_row($vbphrase['product_id'], $product['productid']);
				$product['status'] = $vbphrase['enable'];
			}

			
			print_label_row($vbphrase['status'], $product['status']);

			construct_hidden_code('productid', $product['productid']);
			construct_hidden_code('editing', 1);
		}
		else
		{
			print_table_header($vbphrase['add_new_product']);
			print_input_row($vbphrase['product_id'], 'productid', '', true, 35, 25); // max length = 25
		}
	
		print_input_row($vbphrase['title'], 'title', $product['title']);
		print_input_row($vbphrase['version'], 'version', $product['version']);
		print_input_row($vbphrase['description'], 'description', $product['description']);
		print_input_row($vbphrase['product_url'], 'url', $product['url'], true, 35, 250);
		print_input_row($vbphrase['version_check_url'], 'versioncheckurl', $product['versioncheckurl'], true, 35, 250);
		print_time_row($vbphrase['apm_releasedate'], 'apm_releasedate', $product['apm_releasedate'],1,0);
		print_input_row($vbphrase['apm_author'], 'apm_author', $product['apm_author']);
//		print_input_row($vbphrase['apm_relatedurl'], 'apm_relatedurl', $product['apm_relatedurl']);
		print_textarea_row($vbphrase['apm_extrainfo'], 'apm_extrainfo', $product['apm_extrainfo']);
		print_textarea_row($vbphrase['apm_extraedit'], 'apm_extraedit', $product['apm_extraedit']);
		print_time_row($vbphrase['apm_installdate'], 'apm_installdate', $product['apm_installdate'],1,0);
		
		print_submit_row();
		echo('</tbody>');	

		// if we're editing a product, show the dependancies 

		if ($vbulletin->GPC['showdependancies'] || $vbulletin->GPC['showall'])
		{
			print_form_header('apm_product', 'productdependency');
			construct_hidden_code('productid', $vbulletin->GPC['productid']);
	
			$dependency_types = array(
				'php'       => $vbphrase['php_version'],
				'mysql'     => $vbphrase['mysql_version'],
				'vbulletin' => $vbphrase['vbulletin_version'],
				'product'   => $vbphrase['product_id'] . '</label>&nbsp;<input type="text" class="bginput" name="parentproductid" id="it_parentproductid" value="" size="15" maxlength="25" tabindex="1" /><label>',
			);
	
			$product_dependencies = $db->query_read("
				SELECT *
				FROM " . TABLE_PREFIX . "productdependency
				WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
				ORDER BY dependencytype, parentproductid, minversion
			");
	
			if ($db->num_rows($product_dependencies))
			{
				print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('existing_product_dependencies')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_existing_product_dependencies\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_existing_product_dependencies"]}.gif\" /></a></span> ". $vbphrase['existing_product_dependencies'], 4);
				echo("<tbody id=\"collapseobj_existing_product_dependencies\" style=\"" . $vbcollapse["collapseobj_existing_product_dependencies"] . "\">");

				print_cells_row(array(
					$vbphrase['dependency_type'],
					$vbphrase['compatibility_starts'],
					$vbphrase['incompatible_with'],
					$vbphrase['delete']
				), 1);
	
				while ($product_dependency = $db->fetch_array($product_dependencies))
				{
					if ($product_dependency['dependencytype'] != 'product')
					{
						$dep_type = $dependency_types["$product_dependency[dependencytype]"];
					}
					else
					{
						$dep_type = $vbphrase['product'] . ' - ' . htmlspecialchars_uni($product_dependency['parentproductid']);
					}
	
					$depid = $product_dependency['productdependencyid'];
	
					print_cells_row(array(
						$dep_type,
						"<input type=\"text\" name=\"productdependency[$depid][minversion]\" value=\"" . htmlspecialchars_uni($product_dependency['minversion']) . "\" size=\"25\" maxlength=\"50\" tabindex=\"1\" />",
						"<input type=\"text\" name=\"productdependency[$depid][maxversion]\" value=\"" . htmlspecialchars_uni($product_dependency['maxversion']) . "\" size=\"25\" maxlength=\"50\" tabindex=\"1\" />",
						"<input type=\"checkbox\" name=\"productdependency[$depid][delete]\" value=\"1\" />"
					));
				}
				print_table_break();
				echo('</tbody>');		

			}
				print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('add_new_product_dependency')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_add_new_product_dependency\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_add_new_product_dependency"]}.gif\" /></a></span> ". $vbphrase['add_new_product_dependency'], 4);
				echo("<tbody id=\"collapseobj_add_new_product_dependency\" style=\"" . $vbcollapse["collapseobj_add_new_product_dependency"] . "\">");
			print_radio_row($vbphrase['dependency_type'], 'dependencytype', $dependency_types);
			print_input_row($vbphrase['compatibility_starts_with_version'], 'minversion', '', true, 25, 50);
			print_input_row($vbphrase['incompatible_with_version_and_newer'], 'maxversion', '', true, 25, 50);
	
			print_submit_row();
			echo('</tbody>');	
		}

		// if we're editing a product, show the install/uninstall code options
		// #############################################
		if ($vbulletin->GPC['showinstallcode'] || $vbulletin->GPC['showall'])
		{
			print_form_header('apm_product', 'productcode', false, true, 'showinstallcode');
		construct_hidden_code('productid', $vbulletin->GPC['productid']);

		$productcodes = $db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "productcode
			WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			ORDER BY version
		");

		if ($db->num_rows($productcodes))
		{
			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('install_uninstall_code')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_install_uninstall_code\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_install_uninstall_code"]}.gif\" /></a></span> ". $vbphrase['existing_install_uninstall_code'], 4);
			echo("<tbody id=\"collapseobj_install_uninstall_code\" style=\"" . $vbcollapse["collapseobj_install_uninstall_code"] . "\">");

			print_cells_row(array(
				$vbphrase['version'],
				$vbphrase['install_code'],
				$vbphrase['uninstall_code'],
				$vbphrase['delete']
			), 1);

			$productcodes_grouped = array();
			$productcodes_versions = array();

			while ($productcode = $db->fetch_array($productcodes))
			{
				// have to be careful here, as version numbers are not necessarily unique
				$productcodes_versions["$productcode[version]"] = 1;
				$productcodes_grouped["$productcode[version]"][] = $productcode;
			}

			$productcodes_versions = array_keys($productcodes_versions);
			usort($productcodes_versions, 'version_sort');

			foreach ($productcodes_versions AS $version)
			{
				foreach ($productcodes_grouped["$version"] AS $productcode)
				{
					print_cells_row(array(
						"<input type=\"text\" name=\"productcode[$productcode[productcodeid]][version]\" value=\"" . htmlspecialchars_uni($productcode['version']) . "\" size=\"10\" />",
						"<textarea name=\"productcode[$productcode[productcodeid]][installcode]\" rows=\"5\" cols=\"40\" wrap=\"virtual\" tabindex=\"1\">" . htmlspecialchars($productcode['installcode']) . "</textarea>",
						"<textarea name=\"productcode[$productcode[productcodeid]][uninstallcode]\" rows=\"5\" cols=\"40\" wrap=\"virtual\" tabindex=\"1\">" . htmlspecialchars($productcode['uninstallcode']) . "</textarea>",
						"<input type=\"checkbox\" name=\"productcode[$productcode[productcodeid]][delete]\" value=\"1\" />"
					));
				}
			}
			echo('</tbody>');	

			print_table_break();
		}
		print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('add_new_install_uninstall_code')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_add_new_install_uninstall_code\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_add_new_install_uninstall_code"]}.gif\" /></a></span> ". $vbphrase['add_new_install_uninstall_code'], 4);
		echo("<tbody id=\"collapseobj_add_new_install_uninstall_code\" style=\"" . $vbcollapse["collapseobj_add_new_install_uninstall_code"] . "\">");
	
		print_input_row($vbphrase['version'], 'version');
		print_textarea_row($vbphrase['install_code'], 'installcode');
		print_textarea_row($vbphrase['uninstall_code'], 'uninstallcode');
	
			print_submit_row();
			echo('</tbody>');	
		}
	}

	// ###################### Show plugins ###############################
	if ($vbulletin->GPC['showplugins'] || $vbulletin->GPC['showall'])
	{
	
		print_form_header('apm_product', 'updateactive', false, true, 'updateactive');
		construct_hidden_code('productid', $vbulletin->GPC['productid']);
		construct_hidden_code('showplugins', $vbulletin->GPC['showplugins']);

		print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('plugin_system')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_plugin_system\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_plugin_system"]}.gif\" /></a></span> $vbphrase[plugin_system] <span class=\"smallfont\">" . construct_link_code($vbphrase['add_new_plugin'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=add&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showplugins=" . $vbulletin->GPC['showplugins']) . "</span>", 5);
		echo("<tbody id=\"collapseobj_plugin_system\" style=\"" . $vbcollapse["collapseobj_plugin_system"] . "\">");	
		print_cells_row(array($vbphrase['title'],$vbphrase[hook_location], $vbphrase['product'], $vbphrase['active'], $vbphrase['controls']), 1);
	
		$plugins = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "plugin WHERE product = '" . $vbulletin->GPC['productid'] . "' ORDER BY hookname, title");
		$prevhook = '';
		if ($db->num_rows($plugins) == 0)
		{
				print_description_row(construct_phrase($vbphrase['apm_not_available_x'], $vbphrase['apm_plugins']),0,5,'" align="center');
		}
		while ($plugin = $db->fetch_array($plugins))
		{

			$product = $products[($plugin['product'] ? $plugin['product'] : 'vbulletin')];
			if (!$product)
			{
				$product = array('title' => "<em>$plugin[product]</em>", 'active' => 1);
			}
			if (!$product['active'])
			{
				$product['title'] = "<strike style=\"color:red\">$product[title]</strike>";
			}
	
			$title = htmlspecialchars_uni($plugin['title']);
			$title = ($plugin['active'] AND $product['active']) ? $title : "<strike><font color=\"red\">$title</font></strike>";
	
			print_cells_row(array(
				"<a href=\"apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;pluginid=$plugin[pluginid]\">$title</a>",
				$plugin['hookname'], 
				$product['title'],
				"<input type=\"checkbox\" name=\"active[$plugin[pluginid]]\" value=\"1\"" . ($plugin['active'] ? ' checked="checked"' : '') . " />",
				construct_link_code($vbphrase['edit'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;pluginid=$plugin[pluginid]". "&amp;showplugins=" . $vbulletin->GPC['showplugins']) .
				construct_link_code($vbphrase['delete'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=delete&amp;pluginid=$plugin[pluginid]&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showplugins=" . $vbulletin->GPC['showplugins'])
			));
		}
		print_submit_row($vbphrase['save_active_status'], false, 5);
		echo('</tbody>');	

	}

	// ###################### Show phrases ###############################
	if ($vbulletin->GPC['showphrases'] || $vbulletin->GPC['showall'])
	{
		$vbulletin->GPC['languageid'] = '-10';

		if ($vbulletin->GPC['languageid'] < 0)
		{
			$phrases = $db->query_read("
				SELECT phrase.*, language.title
				FROM " . TABLE_PREFIX . "phrase AS phrase
				LEFT JOIN " . TABLE_PREFIX . "language AS language USING(languageid)
				WHERE product = '" . $vbulletin->GPC['productid'] . "'
#				GROUP BY varname, phrasetypeid
				ORDER BY languageid DESC, fieldname DESC
			");
		}

		$phrasearray = array();
		while ($phrase = $db->fetch_array($phrases))
		{
			// check to see if the languageid is already set
		if ($vbulletin->GPC['languageid'] > 0 AND isset($phrasearray["$phrase[fieldname]"]["$phrase[varname]"]["{$vbulletin->GPC['languageid']}"]))
			{
				continue;
			}
		$phrasearray["{$phrase['fieldname']}"]["{$phrase['varname']}"]["{$phrase['languageid']}"] = $phrase;
		}
	
		unset($phrase);
		$db->free_result($phrases);

		$phrasetypes = fetch_phrasetypes_array();
	
		print_form_header('apm_product', 'editphrase', false, true, 'editphrase');
		construct_hidden_code('showphrases', $vbulletin->GPC['showphrases']);

		print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('phrase_manager')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_phrase_manager\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_phrase_manager"]}.gif\" /></a></span> $vbphrase[phrase_manager] <span class=\"smallfont\">" . construct_link_code($vbphrase['add_new_phrase'], "apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=addphrase&amp;productid=" . $vbulletin->GPC['productid']."&amp;showphrases=". $vbulletin->GPC['showphrases'])."</span>" , 4);
		echo("<tbody id=\"collapseobj_phrase_manager\" style=\"" . $vbcollapse["collapseobj_phrase_manager"] . "\">");		
		if (empty($phrasearray))
		{
			print_description_row(construct_phrase($vbphrase['apm_not_available_x'], $vbphrase['apm_phrases']),0,0,'" align="center');
		}
		
	foreach($phrasearray AS $fieldname => $x)
		{
			// display the header for the phrasetype
			print_description_row($phrasetypes[$fieldname][title], 0, 4, 'thead" align="center');
	
			// sort the phrases alphabetically by $varname
			ksort($x);
			foreach($x AS $varname => $y)
			{
				foreach($y AS $phrase)
				{
					$cell = array();
					$cell[] = '<b>' . $varname . '</b>';
					$cell[] = '<span class="smallfont">' . fetch_language_type_string($phrase['languageid'], $phrase['title']) . '</span>';
					$cell[] = '<span class="smallfont">' . htmlspecialchars_uni($phrase['text']) . '</span>';
					$cell[] = "<input type=\"submit\" class=\"button\" value=\" $vbphrase[edit] \" name=\"e[$fieldname][" . urlencode($varname) . "]\" />";
					print_cells_row($cell, 0, 0, -2);
				}
			}
		} 
		echo('</tbody>');	
		print_table_footer();
	}

	// ###################### Show templates #############################
	if ($vbulletin->GPC['showtemplates'] || $vbulletin->GPC['showall'])
	{
		$vbulletin->GPC['styleid'] = '-1';

		if ($vbulletin->GPC['styleid'] < 0)
		{
			DEVDEBUG("Querying master template ids");
			$templates = $db->query_read("
				SELECT templateid, title, username, version, product, styleid, dateline 
				FROM " . TABLE_PREFIX . "template
				WHERE templatetype = 'template'
					AND styleid = -1
					AND product = '" . $vbulletin->GPC['productid'] . "'
				ORDER BY title
			");

			print_form_header('template', 'edit', false, true, 'showtemplates');
			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('styles')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_styles\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_styles"]}.gif\" /></a></span> $vbphrase[styles] &amp; $vbphrase[templates] <span class=\"smallfont\">" . construct_link_code($vbphrase['add_new_template'], "apm_template.php?" . $vbulletin->session->vars['sessionurl'] . "do=add&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates']) . "</span>",6);
			echo("<tbody id=\"collapseobj_styles\" style=\"" . $vbcollapse["collapseobj_styles"] . "\">");	
			print_cells_row(array(
				$vbphrase['title'], 
				$vbphrase['product'], 
				$vbphrase['last_modified'], 
				$vbphrase['version'], 
				$vbphrase['style']."/".$vbphrase['template'], 
				$vbphrase['controls']), 1);

			if ($db->num_rows($templates) == 0)
			{
				print_description_row(construct_phrase($vbphrase['apm_not_available_x'], $vbphrase['apm_templates']),0,0,'" align="center');
			}
	
			while ($template = $db->fetch_array($templates))
			{			
				$product = $products[($template['product'] ? $template['product'] : 'vbulletin')];
				if (!$product['active'])
				{
					$product['title'] = "<strike>$product[title]</strike>";
				}
				$date = vbdate($vbulletin->options['dateformat'], $template['dateline']);
				$time = vbdate($vbulletin->options['timeformat'], $template['dateline']);
				$last_modified = "<i>$date $time</i> / <b>$template[username]</b>";
	
				$cell = array();
				$cell[] = '<b>' . $template['title'] . '</b>';
				$cell[] = $product['title'];
				$cell[] = $last_modified;
				$cell[] = $template['version'];
				$cell[] = '<b>' . $template['styleid'] ."/". $template['templateid'] .'</b>';
				$cell[] = construct_link_code($vbphrase['edit'], "apm_template.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;templateid=$template[templateid]&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates']) .
				construct_link_code($vbphrase['delete'], "apm_template.php?" . $vbulletin->session->vars['sessionurl'] . "do=delete&amp;templateid=$template[templateid]&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates']);
				print_cells_row($cell, 0, 0, -2);
			}
			echo('</tbody>');		
			print_table_footer();	
		}
	}

	// ###################### Start modify options #######################
	if ($vbulletin->GPC['showsettings'] || $vbulletin->GPC['showall'])
	{
		// print_hr_row();
		// require_once(DIR . '/includes/adminfunctions_apm_options.php');
		$settingphrase = array();
		$phrases = $db->query_read("
			SELECT varname, text
			FROM " . TABLE_PREFIX . "phrase
			WHERE 
				languageid IN(-1, 0, " . LANGUAGEID . ")
			ORDER BY languageid ASC
		");
		while($phrase = $db->fetch_array($phrases))
		{
			$settingphrase["$phrase[varname]"] = $phrase['text'];
		}

		$group = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "settinggroup WHERE product = '" . $vbulletin->GPC['productid'] . "'");
		if (empty($group['grouptitle']))
		{
			$group = $db->query_first("SELECT varname, grouptitle FROM " . TABLE_PREFIX . "setting WHERE product = '" . $vbulletin->GPC['productid'] . "'");
		}
		if (!empty($group['grouptitle']))
		{
			$vbulletin->GPC['dogroup']='[all]';
		}
		// Try to determine GD settings
		if (function_exists('gd_info'))
		{
			$gdinfo = gd_info();
		}
		else if (function_exists('phpinfo') AND function_exists('ob_start'))
		{
			if (@ob_start())
			{
				eval('phpinfo();');
				$info = @ob_get_contents();
				@ob_end_clean();
	
				preg_match('/<b>GD Version<\/b><\/td><td align="left">(.*?)<\/td><\/tr>/si', $info, $hits);
				$gdinfo = array(
					'GD Version' => $hits[1]
				);
			}
		}
	
		if (empty($gdinfo['GD Version']))
		{
			$gdinfo['GD Version'] = $vbphrase['n_a'];
		}
	
		$vbulletin->input->clean_array_gpc('r', array(
			'advanced' => TYPE_BOOL,
			'expand'   => TYPE_BOOL,
		));
	
		// display links to settinggroups and create settingscache
		$settingscache = array();
		$options = array('[all]' => '-- ' . $vbphrase['show_all_settings'] . ' --');
		$lastgroup = '';

		$settings = $db->query_read("
			SELECT setting.*, settinggroup.grouptitle
			FROM " . TABLE_PREFIX . "settinggroup AS settinggroup
			LEFT JOIN " . TABLE_PREFIX . "setting AS setting USING(grouptitle)
			WHERE settinggroup.product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			OR setting.product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'
			ORDER BY settinggroup.displayorder, setting.displayorder
		");
	
		if (empty($vbulletin->GPC['dogroup']) AND $vbulletin->GPC['expand'])
		{
			while ($setting = $db->fetch_array($settings))
			{
				$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
				if ($setting['grouptitle'] != $lastgroup)
				{
					$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
					$grouptitle = $settingphrase["settinggroup_$setting[grouptitle]"];
				}
				$options["$grouptitle"]["$setting[varname]"] = $settingphrase["setting_$setting[varname]_title"];
				$lastgroup = $setting['grouptitle'];
			}
	
			$altmode = 0;
			$linktext =& $vbphrase['collapse_setting_groups'];
		}
		else
		{
			while ($setting = $db->fetch_array($settings))
			{
				$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
				if ($setting['grouptitle'] != $lastgroup)
				{
					$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
					$options["$setting[grouptitle]"] = $settingphrase["settinggroup_$setting[grouptitle]"];
				}
				$lastgroup = $setting['grouptitle'];
			}
	
			$altmode = 1;
			$linktext =& $vbphrase['expand_setting_groups'];
		}
		$db->free_result($settings);

		$optionsmenu = "\n\t<select name=\"" . iif($vbulletin->GPC['expand'], 'varname', 'dogroup') . "\" class=\"bginput\" tabindex=\"1\" " . iif(empty($vbulletin->GPC['dogroup']), 'ondblclick="this.form.submit();" size="20"', 'onchange="this.form.submit();"') . " style=\"width:350px\">\n" . construct_select_options($options, iif($vbulletin->GPC['dogroup'], $vbulletin->GPC['dogroup'], '[all]')) . "\t</select>\n\t";

		if (empty($vbulletin->GPC['dogroup'])) // show the big <select> with no options
		{
			//print_form_header();
			print_table_start(1);
			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('setting_group')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_setting_group\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_setting_group"]}.gif\" /></a></span> $vbphrase[settings_and_options] <span class=\"smallfont\">" . construct_link_code($vbphrase['add_new_setting_group'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=addgroup&amp;productid=" . $vbulletin->GPC['productid']) . ' ' . construct_link_code($vbphrase['add_new_setting'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=addsetting&amp;productid=" . $vbulletin->GPC['productid'])."</span>");
			echo("<tbody id=\"collapseobj_setting_group\" style=\"" . $vbcollapse["collapseobj_setting_group"] . "\">");
			print_description_row(construct_phrase($vbphrase['apm_not_available_x'], $vbphrase['apm_settings']),0,0,'" align="center');
		}
		else 
		{
			// show selected settings
			print_form_header('apm_options', 'dooptions', false, true, 'dooptions');
			construct_hidden_code('dogroup', $vbulletin->GPC['dogroup']);
			construct_hidden_code('advanced', $vbulletin->GPC['advanced']);
			construct_hidden_code('productid', $vbulletin->GPC['productid']);
	
			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('setting_group')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_setting_group\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_setting_group"]}.gif\" /></a></span> $vbphrase[settings_and_options] <span class=\"smallfont\">" . construct_link_code($vbphrase['add_new_setting_group'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=addgroup&amp;productid=" . $vbulletin->GPC['productid']) . ' ' . construct_link_code($vbphrase['add_new_setting'], "apm_options.php?" . $vbulletin->session->vars['sessionurl'] . "do=addsetting&amp;productid=" . $vbulletin->GPC['productid']) ."</span>");
			echo("<tbody id=\"collapseobj_setting_group\" style=\"" . $vbcollapse["collapseobj_setting_group"] . "\">");	
			
			if ($vbulletin->GPC['dogroup'] == '[all]') // show all settings groups
			{
				foreach ($grouptitlecache AS $curgroup => $group)
				{
					print_setting_group_apm($curgroup, $vbulletin->GPC['advanced']);
				}
			}
			else
			{
				print_setting_group_apm($vbulletin->GPC['dogroup'], $vbulletin->GPC['advanced']);
			}
			print_submit_row($vbphrase['save'], 0, 9);
		}
	print_table_footer();	
//			echo('</tbody></table><br />');	
	}

	// ###################### Show crons #############################
	if ($vbulletin->GPC['showcrons'] || $vbulletin->GPC['showall'])
	{
		function fetch_cron_timerule($cron)
		{
			global $vbphrase;
	
			$t = array(
				'hour'		=> $cron['hour'],
				'day'		=> $cron['day'],
				'month'		=> -1,
				'weekday'	=> $cron['weekday']
			);
	
			// set '-1' fields as
			foreach ($t AS $field => $value)
			{
				$t["$field"] = iif($value == -1, '*', $value);
			}
	
			if (is_numeric($cron['minute']))
			{
				$cron['minute'] = array(0 => $cron['minute']);
			}
			else
			{
				$cron['minute'] = unserialize($cron['minute']);
				if (!is_array($cron['minute']))
				{
					$cron['minute'] = array(-1);
				}
			}
	
			if ($cron['minute'][0] == -1)
			{
				$t['minute'] = '*';
			}
			else
			{
				$minutes = array();
				foreach ($cron['minute'] AS $nextminute)
				{
					$minutes[] = str_pad(intval($nextminute), 2, 0, STR_PAD_LEFT);
				}
				$t['minute'] = implode(', ', $minutes);
			}
	
			// set weekday to override day of month if necessary
			$days = array('sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday');
			if ($t['weekday'] != '*')
			{
				$day = $days[intval($t['weekday'])];
				$t['weekday'] = $vbphrase[$day . "_abbr"];
				$t['day'] = '*';
			}
	
			return $t;
		}

		$crons = $db->query_read("
			SELECT cron.*, IF(product.productid IS NULL OR product.active = 1, cron.active, 0) AS effective_active
			FROM " . TABLE_PREFIX . "cron AS cron
			LEFT JOIN " . TABLE_PREFIX . "product AS product ON (cron.product = product.productid)
			WHERE product = '" . $vbulletin->GPC['productid'] . "'
			ORDER BY effective_active DESC, nextrun
		");

	?>
	<script type="text/javascript">
	<!--
	function js_cron_jump(cronid)
	{
		task = eval("document.cpform.c" + cronid + ".options[document.cpform.c" + cronid + ".selectedIndex].value");
		switch (task)
		{
			case 'edit': window.location = "apm_cronadmin.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=edit&productid=<?php echo  $vbulletin->GPC['productid']; ?>&cronid=" + cronid; break;
			case 'kill': window.location = "apm_cronadmin.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=remove&amp;productid=<?php echo  "$vbulletin->GPC['productid']";?>&cronid=" + cronid; break;
			case 'switchactive': window.location = "apm_cronadmin.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=switchactive&amp;productid=<?php echo  "$vbulletin->GPC['productid']";?>&cronid=" + cronid + "&hash=<?php echo CP_SESSIONHASH; ?>"; break;
			default: return false; break;
		}
	}
	function js_run_cron(cronid)
	{
		window.location = "<?php echo "apm_cronadmin.php?" . $vbulletin->session->vars['sessionurl_js'] . "do=runcron&productid=" . $vbulletin->GPC['productid'] . "&cronid="; ?>" + cronid;
	}
	//-->
	</script>
	<?php

	print_form_header('apm_cronadmin', 'updateenabled');

			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('scheduled_task_manager')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_scheduled_task_manager\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_scheduled_task_manager"]}.gif\" /></a></span> $vbphrase[scheduled_task_manager] <span class=\"smallfont\">" . construct_link_code($vbphrase['add_new_scheduled_task'], "apm_cronadmin.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;productid=" . $vbulletin->GPC['productid']) . "</span>",9);
			echo("<tbody id=\"collapseobj_scheduled_task_manager\" style=\"" . $vbcollapse["collapseobj_scheduled_task_manager"] . "\">");	
	
		construct_hidden_code('productid', $vbulletin->GPC['productid']);

		print_cells_row(array(
		'',
		$vbphrase['min_abbr'],
		$vbphrase['hour_abbr'],
		$vbphrase['day_abbr'],
		$vbphrase['month_abbr'],
		$vbphrase['dow_acronym'],
		$vbphrase['title'],
		$vbphrase['next_time'],
		$vbphrase['controls']
	), 1, '', 1);

	while ($cron = $db->fetch_array($crons))
	{
		$options = array(
			'edit' => $vbphrase['edit'],
			'switchactive' => ($cron['effective_active'] ? $vbphrase['disable'] : $vbphrase['enable'])
		);
		if (!$cron['volatile'] OR $vbulletin->debug)
		{
			$options['kill'] = $vbphrase['delete'];
		}

		$item_title = htmlspecialchars_uni($vbphrase['task_' . $cron['varname'] . '_title']);
		if (isset($vbphrase['task_' . $cron['varname'] . '_title']))
		{
			$item_title = htmlspecialchars_uni($vbphrase['task_' . $cron['varname'] . '_title']);
		}
		else
		{
			$item_title = $cron['varname'];
		}
		if (!$cron['effective_active'])
		{
			$item_title = "<strike><font color=\"red\">$item_title</font></strike>";
		}
		$item_desc = htmlspecialchars_uni($vbphrase['task_' . $cron['varname'] . '_desc']);

		$timerule = fetch_cron_timerule($cron);

		$cell = array(
			"<input type=\"checkbox\" name=\"enabled[$cron[varname]]\" value=\"1\" title=\"$vbphrase[enabled]\" id=\"cb_enabled_$cron[varname]\" tabindex=\"1\"" . ($cron['active'] ? ' checked="checked"' : '') . " />",
			$timerule['minute'],
			$timerule['hour'],
			$timerule['day'],
			$timerule['month'],
			$timerule['weekday'],
			"<label for=\"cb_enabled_$cron[varname]\"><strong>$item_title</strong><br /><span class=\"smallfont\">$item_desc</span></label>",
			'<div style="white-space:nowrap">' . ($cron['effective_active'] ? vbdate($vbulletin->options['dateformat'], $cron['nextrun'], true) . ($vbulletin->options['yestoday'] != 2 ? '<br />' . vbdate($vbulletin->options['timeformat'], $cron['nextrun']) : '') : $vbphrase['n_a']) . '</div>',
			"\n\t<a href=\"apm_cronadmin.php?". $vbulletin->session->vars['sessionurl_js'] ."do=edit&productid=".$vbulletin->GPC['productid']."&cronid=$cron[cronid]\">$vbphrase[edit]</a>
					<a href=\"apm_cronadmin.php?". $vbulletin->session->vars['sessionurl_js'] ."do=remove&productid=".$vbulletin->GPC['productid']."&cronid=$cron[cronid]\">$vbphrase[delete]</a>
			<br>\n\t" .
			"\n\t<input type=\"button\" class=\"button\" value=\"". ($cron['effective_active'] ? $vbphrase['disable'] : $vbphrase['enable']) ."\" onclick=\"window.location='apm_cronadmin.php? ". $vbulletin->session->vars['sessionurl_js'] ."do=switchactive&amp;productid=". $vbulletin->GPC['productid'] ."&cronid=". $cron[cronid] . "&hash=". CP_SESSIONHASH ."'\" ".
			"\n\t<input type=\"button\" class=\"button\" value=\"$vbphrase[run_now]\" onclick=\"js_run_cron($cron[cronid]);\" />"
		);
		print_cells_row($cell, 0, '', -6);
	}

	print_description_row("<div class=\"smallfont\" align=\"center\">$vbphrase[all_times_are_gmt_x_time_now_is_y]</div>", 0, 9, 'thead');
	print_submit_row($vbphrase['save_enabled_status'], 0, 9);
	print_table_footer();	
//			echo('</tbody></table><br />');	

	}	//End showcrons

	// ###################### Show Admin Help #############################
	if ($vbulletin->GPC['showadminhelp'] || $vbulletin->GPC['showall'])
	{
	print_form_header('apm_adminhelp', '');
			//print_form_header();
//			print_table_start(1);
			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('adminhelp')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_adminhelp\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_adminhelp"]}.gif\" /></a></span> admin help");
			echo("<tbody id=\"collapseobj_adminhelp\" style=\"" . $vbcollapse["collapseobj_adminhelp"] . "\">");
			print_description_row("<b> --    <a href=\"help.php?do=manage\"> </a> -- </b>",0,0,'" align="center');
			print_table_footer();	
//			echo('</tbody></table><br />');	
	}	//End adminhelp

	// ###################### Show FAQ #############################
	if ($vbulletin->GPC['showfaq'] || $vbulletin->GPC['showall'])
	{
	print_form_header('apm_faq', '');
			//print_form_header();
//			print_table_start(1);
			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('faq')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_faq\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_faq"]}.gif\" /></a></span> FAQ");
			echo("<tbody id=\"collapseobj_faq\" style=\"" . $vbcollapse["collapseobj_faq"] . "\">");
			print_description_row("<b> --    <a href=\"faq.php\"> </a>  -- </b>",0,0,'" align="center');
			print_table_footer();	
//			echo('</tbody></table><br />');	
	}	//End FAQ

	// ###################### Show Template Management System #############################

	if (($vbulletin->GPC['showTMS']  || $vbulletin->GPC['showall']) AND $products['tms'] AND $products['tms']['active'])
	{
		if ($vbulletin->GPC['styleid'] < 0)
		{
			DEVDEBUG("Querying master template ids");
//				SELECT templateedit.templateeditid, templateedit.styleid, templateedit.username, templateedit.dateline, templateedit.active, templateeditlocation.templateeditlocationid,templateeditlocation.varname,templateeditlocation.title,templateeditlocation.template,templateeditlocation.product,templateeditlocation.addstyleid

			$templates = $db->query_read("
				SELECT templateedit.*, templateeditlocation.*
				FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
				LEFT JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON(templateedit.varname=templateeditlocation.varname)
				WHERE templateeditlocation.product = '" . $vbulletin->GPC['productid'] . "'
				ORDER BY templateeditlocation.templateeditlocationid
			");

			print_form_header('templateedits', 'edit', false, true, 'templateedit');
			print_table_header("<span style=\"float: right\"><a href=\"#\" onclick=\"return toggle_collapse('tms')\"><img alt=\"\" border=\"0\" style=\"vertical-align: middle\" id=\"collapseimg_tms\" src=\"../images/buttons/collapse_alt{$vbcollapse["collapseimg_tms"]}.gif\" /></a></span> Template Management System <span class=\"smallfont\">" . construct_link_code("Test template modifications", "templateedits.php?" . $vbulletin->session->vars['sessionurl'] . "do=test") . construct_link_code("Template Management Manager", "templateedits.php?" . $vbulletin->session->vars['sessionurl']) ."</span>",7);
			
			echo("<tbody id=\"collapseobj_tms\" style=\"" . $vbcollapse["collapseobj_tms"] . "\">");	
			print_cells_row(array(
				$vbphrase['title'],
				$vbphrase['template'],
				$vbphrase['product'], 
				$vbphrase['last_modified'],
				$vbphrase['version'], 
				$vbphrase['style'], 
//				$vbphrase['style']."/".$vbphrase['template'], 
				$vbphrase['controls']), 1);

			if ($db->num_rows($templates) == 0)
			{
				print_description_row(construct_phrase($vbphrase['apm_not_available_x'], "Template Modification"),0,0,'" align="center');
			}
	
			while ($template = $db->fetch_array($templates))
			{
				$product = $products[($template['product'] ? $template['product'] : 'vbulletin')];
				if (!$product['active'])
				{
					$product['title'] = "<strike>$product[title]</strike>";
				}
				$date = vbdate($vbulletin->options['dateformat'], $template['dateline']);
				$time = vbdate($vbulletin->options['timeformat'], $template['dateline']);
				$last_modified = "<i>$date $time</i> / <b>$template[username]</b>";
	
				$cell = array();
				$cell[] = '<b>' . $template['title'] . '</b>';
				$cell[] = '<b>' . $template['template'] . '</b>';
				$cell[] = $product['title'];
				$cell[] = $last_modified;
				$cell[] = $template['version'];
				$cell[] = '<b>' . $template['addstyleid'] .'</b>';
				$cell[] = construct_link_code($vbphrase['edit'], "templateedits.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;templateeditid=$template[templateeditid]&amp;product=" . $vbulletin->GPC['productid']) .
				construct_link_code($vbphrase['test'], "templateedits.php?" . $vbulletin->session->vars['sessionurl'] . "do=test&amp;templateeditid=$template[templateeditid]") .
				construct_link_code($vbphrase['delete'], "templateedits.php?" . $vbulletin->session->vars['sessionurl'] . "do=delete&amp;templateeditid=$template[templateeditid]&amp;product=" . $vbulletin->GPC['productid']);
				print_cells_row($cell, 0, 0, -2);
			}
			echo('</tbody>');		
			print_table_footer();	
		}

	}	//End TMS

}
print_cp_footer();

/*======================================================================*\
|| #################################################################### ||
|| # CVS: apm_product.php,v 4.0.001 - Revision: 091203
|| # ref: $RCSfile: adminfunctions_options.php,v $ - $Revision: 32878 $
|| # ref: $RCSfile: plugin.php,v $ - $Revision: 32878 $
|| # ref: $RCSfile: phrase.php,v $ - $Revision: 28366 $
|| #################################################################### ||
\*======================================================================*/
?>
